/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata;

import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.renderer.ODataRenderException;
import scala.Option;

public final class ODataRendererUtils {
    private ODataRendererUtils() {
    }

    public static String getContextURL(ODataUri oDataUri, EntityDataModel entityDataModel) throws ODataRenderException {
        return ODataRendererUtils.getContextURL(oDataUri, entityDataModel, false);
    }

    public static String getContextURL(ODataUri oDataUri, EntityDataModel entityDataModel, boolean isPrimitive) throws ODataRenderException {
        if (ODataUriUtil.isActionCallUri((ODataUri)oDataUri) || ODataUriUtil.isFunctionCallUri((ODataUri)oDataUri)) {
            return ODataRendererUtils.buildContextUrlFromOperationCall(oDataUri, entityDataModel, isPrimitive);
        }
        Option contextOption = ODataUriUtil.getContextUrl((ODataUri)oDataUri);
        if (contextOption.isEmpty()) {
            throw new ODataRenderException("Could not construct context");
        }
        return (String)contextOption.get();
    }

    public static String buildContextUrlFromOperationCall(ODataUri oDataUri, EntityDataModel entityDataModel, boolean isPrimitive) {
        String serviceRoot = oDataUri.serviceRoot();
        String returnType = ODataUriUtil.getOperationReturnType((ODataUri)oDataUri, (EntityDataModel)entityDataModel);
        return serviceRoot + "/" + "$metadata" + "#" + returnType + (isPrimitive ? "" : "/$entity");
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String message, Object ... args) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format(message, args));
        }
        return reference;
    }
}

