/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.processor.write;

import com.sdl.odata.api.ODataBadRequestException;
import com.sdl.odata.api.ODataClientException;
import com.sdl.odata.api.ODataErrorCode;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.ODataEdmException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.NavigationProperty;
import com.sdl.odata.api.edm.model.PropertyRef;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.processor.ODataProcessorException;
import com.sdl.odata.api.processor.ProcessorResult;
import com.sdl.odata.api.processor.datasource.DataSource;
import com.sdl.odata.api.processor.datasource.ODataDataSourceException;
import com.sdl.odata.api.processor.datasource.ODataTargetTypeException;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import scala.Option;
import scala.collection.immutable.Map;

public abstract class WriteMethodHandler {
    private final ODataRequest request;
    private final EntityDataModel entityDataModel;
    private final ODataUri oDataUri;
    private final DataSourceFactory dataSourceFactory;
    private final ODataRequestContext requestContext;

    public WriteMethodHandler(ODataRequestContext requestContext, DataSourceFactory dataSourceFactory) {
        this.oDataUri = WriteMethodHandler.checkNotNull(requestContext.getUri());
        this.request = WriteMethodHandler.checkNotNull(requestContext.getRequest());
        this.entityDataModel = WriteMethodHandler.checkNotNull(requestContext.getEntityDataModel());
        this.dataSourceFactory = WriteMethodHandler.checkNotNull(dataSourceFactory);
        this.requestContext = requestContext;
    }

    public abstract ProcessorResult handleWrite(Object var1) throws ODataException;

    protected TargetType getTargetType() throws ODataTargetTypeException {
        Option targetTypeOption = ODataUriUtil.resolveTargetType((ODataUri)this.getoDataUri(), (EntityDataModel)this.getEntityDataModel());
        if (targetTypeOption.isEmpty()) {
            throw new ODataTargetTypeException("The target type of this URI cannot be determined: " + this.getRequest().getUri());
        }
        return (TargetType)targetTypeOption.get();
    }

    protected DataSource getDataSource(String entityType) throws ODataDataSourceException {
        return this.dataSourceFactory.getDataSource(this.requestContext, entityType);
    }

    protected boolean isMinimalReturnPreferred() {
        return this.getRequest().getPrefer().contains("return=minimal");
    }

    protected java.util.Map<String, String> getResponseHeaders(Object entity) throws ODataEdmException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Location", String.format("%s/%s(%s)", this.getoDataUri().serviceRoot(), EntityDataModelUtil.getEntitySetByEntity((EntityDataModel)this.getEntityDataModel(), (Object)entity).getName(), EntityDataModelUtil.formatEntityKey((EntityDataModel)this.getEntityDataModel(), (Object)entity)));
        return headers;
    }

    protected void validateKeys(Object entity, EntityType type) throws ODataClientException, ODataProcessorException {
        java.util.Map oDataUriKeyValues = ODataUriUtil.asJavaMap((Map)ODataUriUtil.getEntityKeyMap((ODataUri)this.getoDataUri(), (EntityDataModel)this.getEntityDataModel()));
        java.util.Map<String, Object> keyValues = this.getKeyValues(entity, type);
        if (oDataUriKeyValues.size() != keyValues.size()) {
            throw new ODataClientException(ODataErrorCode.PROCESSOR_ERROR, "Number of keys don't match");
        }
        for (Map.Entry oDataUriEntry : oDataUriKeyValues.entrySet()) {
            String oDataUriKey = (String)oDataUriEntry.getKey();
            Object value = keyValues.get(oDataUriKey);
            if (value != null && this.normalize(value).equals(this.normalize(oDataUriEntry.getValue()))) continue;
            throw new ODataClientException(ODataErrorCode.PROCESSOR_ERROR, "Key/Values in OData URI and the entity don't match");
        }
    }

    private java.util.Map<String, Object> getKeyValues(Object entity, EntityType entityType) throws ODataProcessorException {
        HashMap<String, Object> keyValues = new HashMap<String, Object>();
        for (PropertyRef propertyRef : entityType.getKey().getPropertyRefs()) {
            try {
                Field keyField = entity.getClass().getDeclaredField(propertyRef.getPath());
                keyField.setAccessible(true);
                keyValues.put(propertyRef.getPath(), keyField.get(entity));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ODataProcessorException(ODataErrorCode.PROCESSOR_ERROR, "Not possible to extract the key/values from the entity", (Throwable)e);
            }
        }
        return keyValues;
    }

    private Object normalize(Object value) {
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof Short) {
            return new BigDecimal(((Short)value).shortValue());
        }
        if (value instanceof Byte) {
            return new BigDecimal(((Byte)value).byteValue());
        }
        if (value instanceof scala.math.BigDecimal) {
            return ((scala.math.BigDecimal)value).bigDecimal();
        }
        return value;
    }

    protected void validateTargetType(Object entity) throws ODataProcessorException, ODataTargetTypeException {
        if (!this.getEntityDataModel().getType(entity.getClass()).getFullyQualifiedName().equals(this.getTargetType().typeName())) {
            throw new ODataProcessorException(ODataErrorCode.PROCESSOR_ERROR, "Entity to persist does not match specified Resource name");
        }
    }

    protected void validateProperties(Object entity, EntityDataModel edm) throws ODataException {
        Type type = edm.getType(entity.getClass());
        if (!(type instanceof StructuredType)) {
            return;
        }
        EntityDataModelUtil.visitProperties((EntityDataModel)edm, (StructuredType)((StructuredType)type), property -> {
            Object value = EntityDataModelUtil.getPropertyValue((StructuralProperty)property, (Object)entity);
            if (value == null) {
                if (!property.isNullable()) {
                    throw new ODataBadRequestException("The property '" + property.getName() + "' is required to be non-empty in an entity of type: " + type.getFullyQualifiedName());
                }
            } else if (!(property instanceof NavigationProperty)) {
                this.validateProperties(value, edm);
            }
        });
    }

    public ODataRequest getRequest() {
        return this.request;
    }

    public EntityDataModel getEntityDataModel() {
        return this.entityDataModel;
    }

    public ODataRequestContext getODataRequestContext() {
        return this.requestContext;
    }

    public ODataUri getoDataUri() {
        return this.oDataUri;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        return reference;
    }
}

