/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.processor.write;

import com.sdl.odata.api.ODataBadRequestException;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.MetaType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.processor.ProcessorResult;
import com.sdl.odata.api.processor.datasource.DataSource;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.processor.write.WriteMethodHandler;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchMethodHandler
extends WriteMethodHandler {
    private static Logger log = LoggerFactory.getLogger(PatchMethodHandler.class);

    public PatchMethodHandler(ODataRequestContext requestContext, DataSourceFactory dataSourceFactory) {
        super(requestContext, dataSourceFactory);
    }

    @Override
    public ProcessorResult handleWrite(Object entity) throws ODataException {
        if (ODataUriUtil.isRefPathUri((ODataUri)this.getoDataUri())) {
            throw new ODataBadRequestException("The URI of a PATCH request must not be an entity reference URI.");
        }
        if (entity == null) {
            throw new ODataBadRequestException("The body of a PATCH request must contain a valid entity.");
        }
        return this.processRequest(entity);
    }

    private ProcessorResult processRequest(Object entity) throws ODataException {
        TargetType targetType = this.getTargetType();
        if (!targetType.isCollection()) {
            Type type = this.getEntityDataModel().getType(targetType.typeName());
            if (!MetaType.ENTITY.equals((Object)type.getMetaType())) {
                throw new ODataBadRequestException("The body of a PATCH request must contain a valid entity.");
            }
            this.validateProperties(entity, this.getEntityDataModel());
            DataSource dataSource = this.getDataSource(type.getFullyQualifiedName());
            log.debug("Data source found for type '{}'", (Object)type.getFullyQualifiedName());
            Map<String, String> headers = this.getResponseHeaders(entity);
            this.validateTargetType(entity);
            this.validateKeys(entity, (EntityType)type);
            Object updatedEntity = dataSource.update(this.getoDataUri(), entity, this.getEntityDataModel());
            if (this.isMinimalReturnPreferred()) {
                return new ProcessorResult(ODataResponse.Status.NO_CONTENT, headers);
            }
            return new ProcessorResult(ODataResponse.Status.OK, updatedEntity, headers);
        }
        throw new ODataBadRequestException("The URI for a PATCH request should refer to the single entity to be updated, not to a collection of entities.");
    }
}

