/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.processor.write;

import com.sdl.odata.api.ODataBadRequestException;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.MetaType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.processor.ProcessorResult;
import com.sdl.odata.api.processor.datasource.DataSource;
import com.sdl.odata.api.processor.datasource.ODataTargetTypeException;
import com.sdl.odata.api.processor.datasource.TransactionalDataSource;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.service.ChangeSetEntity;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.processor.write.util.WriteMethodUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class BatchMethodHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BatchMethodHandler.class);
    private final List<ChangeSetEntity> changeSetEntities;
    private final EntityDataModel entityDataModel;
    private final DataSourceFactory dataSourceFactory;
    private boolean isTransactionStarted = false;
    private String transactionID = UUID.randomUUID().toString();
    private int requestsProcessedCount = 0;

    public BatchMethodHandler(ODataRequestContext requestContext, DataSourceFactory dataSourceFactory, List<ChangeSetEntity> changeSetEntries) {
        this.changeSetEntities = changeSetEntries;
        this.entityDataModel = requestContext.getEntityDataModel();
        this.dataSourceFactory = dataSourceFactory;
    }

    public List<ProcessorResult> handleWrite() throws ODataException {
        LOG.info("Handling transactional operations per each odata request.");
        ArrayList<ProcessorResult> resultList = new ArrayList<ProcessorResult>();
        for (ChangeSetEntity changeSetEntity : this.changeSetEntities) {
            ODataRequestContext requestContext = changeSetEntity.getRequestContext();
            ODataUri requestUri = requestContext.getUri();
            ODataRequest.Method method = requestContext.getRequest().getMethod();
            ProcessorResult result = null;
            if (method == ODataRequest.Method.POST) {
                result = this.handlePOST(requestContext, requestUri, changeSetEntity);
            } else if (method == ODataRequest.Method.PUT || method == ODataRequest.Method.PATCH) {
                result = this.handlePutAndPatch(requestContext, requestUri, changeSetEntity);
            } else if (method == ODataRequest.Method.DELETE) {
                result = this.handleDelete(requestContext, requestUri, changeSetEntity);
            }
            resultList.add(result);
            if (result.getStatus() != ODataResponse.Status.BAD_REQUEST) continue;
            break;
        }
        return resultList;
    }

    private ProcessorResult handlePOST(ODataRequestContext requestContext, ODataUri oDataUri, ChangeSetEntity changeSetEntity) {
        LOG.info("Handling POST operation");
        Object entityData = changeSetEntity.getOdataEntity();
        HashMap<String, String> headers = new HashMap<String, String>();
        ODataRequest odataRequest = requestContext.getRequest();
        headers.putAll(odataRequest.getHeaders());
        headers.put("changeSetId", changeSetEntity.getChangeSetId());
        TransactionalDataSource dataSource = null;
        try {
            dataSource = (TransactionalDataSource)this.getDataSourceFromTargetType(requestContext, this.getRequestType(odataRequest, oDataUri), entityData);
            headers.putAll(WriteMethodUtil.getResponseHeaders(entityData, oDataUri, this.entityDataModel));
            this.starTransactionIfNeeded(dataSource);
            Object createdEntity = dataSource.create(oDataUri, entityData, this.entityDataModel, this.transactionID);
            this.increaseProcessedAndCloseTransactionIfNeeded(dataSource);
            if (WriteMethodUtil.isMinimalReturnPreferred(odataRequest)) {
                return new ProcessorResult(ODataResponse.Status.NO_CONTENT, headers);
            }
            return new ProcessorResult(ODataResponse.Status.CREATED, createdEntity, headers, requestContext);
        }
        catch (ODataException ex) {
            return this.prepareFailedResult(dataSource, ex.getMessage(), headers, requestContext);
        }
    }

    private ProcessorResult handleDelete(ODataRequestContext requestContext, ODataUri odataUri, ChangeSetEntity changeSetEntity) {
        LOG.debug("Handling DELETE operation");
        HashMap<String, String> headers = new HashMap<String, String>();
        ODataRequest oDataRequest = requestContext.getRequest();
        headers.putAll(oDataRequest.getHeaders());
        headers.put("changeSetId", changeSetEntity.getChangeSetId());
        TransactionalDataSource dataSource = null;
        try {
            Option singletonName = ODataUriUtil.getSingletonName((ODataUri)odataUri);
            dataSource = (TransactionalDataSource)this.getDataSourceFromTargetName(requestContext, this.getRequestType(oDataRequest, odataUri).getFullyQualifiedName());
            this.starTransactionIfNeeded(dataSource);
            if (singletonName.isDefined()) {
                throw new ODataBadRequestException("The URI refers to the singleton '" + (String)singletonName.get() + "'. Singletons cannot be deleted.");
            }
            dataSource.delete(odataUri, this.entityDataModel, this.transactionID);
            this.increaseProcessedAndCloseTransactionIfNeeded(dataSource);
            return new ProcessorResult(ODataResponse.Status.NO_CONTENT, null, headers, requestContext);
        }
        catch (ODataException e) {
            return this.prepareFailedResult(dataSource, e.getMessage(), headers, requestContext);
        }
    }

    private ProcessorResult handlePutAndPatch(ODataRequestContext requestContext, ODataUri requestUri, ChangeSetEntity changeSetEntity) {
        LOG.debug("Handling PUT or PATCH operation");
        Object entityData = changeSetEntity.getOdataEntity();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("changeSetId", changeSetEntity.getChangeSetId());
        TransactionalDataSource dataSource = null;
        try {
            ODataRequest oDataRequest = requestContext.getRequest();
            TargetType targetType = WriteMethodUtil.getTargetType(oDataRequest, this.entityDataModel, requestUri);
            if (targetType.isCollection()) {
                throw new ODataBadRequestException("The URI for a PATCH request should refer to the single entity to be updated, not to a collection of entities.");
            }
            headers.putAll(WriteMethodUtil.getResponseHeaders(entityData, requestUri, this.entityDataModel));
            WriteMethodUtil.validateTargetType(entityData, oDataRequest, this.entityDataModel, requestUri);
            Type type = this.entityDataModel.getType(targetType.typeName());
            WriteMethodUtil.validateKeys(entityData, (EntityType)type, requestUri, this.entityDataModel);
            dataSource = (TransactionalDataSource)this.getDataSourceFromTargetType(requestContext, type, entityData);
            this.starTransactionIfNeeded(dataSource);
            Object updatedEntity = dataSource.update(requestUri, entityData, this.entityDataModel, this.transactionID);
            this.increaseProcessedAndCloseTransactionIfNeeded(dataSource);
            headers.putAll(oDataRequest.getHeaders());
            if (WriteMethodUtil.isMinimalReturnPreferred(oDataRequest)) {
                return new ProcessorResult(ODataResponse.Status.NO_CONTENT, headers);
            }
            return new ProcessorResult(ODataResponse.Status.OK, updatedEntity, headers, requestContext);
        }
        catch (ODataException ex) {
            return this.prepareFailedResult(dataSource, ex.getMessage(), headers, requestContext);
        }
    }

    private ProcessorResult prepareFailedResult(TransactionalDataSource dataSource, String message, Map<String, String> headers, ODataRequestContext requestContext) {
        if (dataSource != null) {
            dataSource.endTransaction(this.transactionID, false);
        }
        return new ProcessorResult(ODataResponse.Status.BAD_REQUEST, (Object)message, headers, requestContext);
    }

    private Type getRequestType(ODataRequest oDataRequest, ODataUri oDataUri) throws ODataTargetTypeException {
        TargetType targetType = WriteMethodUtil.getTargetType(oDataRequest, this.entityDataModel, oDataUri);
        return this.entityDataModel.getType(targetType.typeName());
    }

    private void starTransactionIfNeeded(TransactionalDataSource dataSource) {
        if (!this.isTransactionStarted) {
            dataSource.startTransaction(this.transactionID);
            this.isTransactionStarted = true;
        }
    }

    private void increaseProcessedAndCloseTransactionIfNeeded(TransactionalDataSource dataSource) {
        ++this.requestsProcessedCount;
        if (this.requestsProcessedCount == this.changeSetEntities.size()) {
            LOG.info("Ending the transaction with id: {} ", (Object)this.transactionID);
            dataSource.endTransaction(this.transactionID, true);
        }
    }

    private DataSource getDataSourceFromTargetType(ODataRequestContext requestContext, Type type, Object entityData) throws ODataException {
        if (!MetaType.ENTITY.equals((Object)type.getMetaType())) {
            throw new ODataBadRequestException("The body of the write request must contain a valid entity.");
        }
        WriteMethodUtil.validateProperties(entityData, this.entityDataModel);
        return WriteMethodUtil.getDataSource(requestContext, type.getFullyQualifiedName(), this.dataSourceFactory);
    }

    private DataSource getDataSourceFromTargetName(ODataRequestContext requestContext, String entityType) throws ODataException {
        return this.dataSourceFactory.getDataSource(requestContext, entityType);
    }
}

