/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.processor.datasource.factory;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntitySet;
import com.sdl.odata.api.edm.model.Singleton;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.processor.datasource.DataSource;
import com.sdl.odata.api.processor.datasource.DataSourceProvider;
import com.sdl.odata.api.processor.datasource.ODataDataSourceException;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.processor.query.QueryOperation;
import com.sdl.odata.api.processor.query.strategy.QueryOperationStrategy;
import com.sdl.odata.api.service.ODataRequestContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataSourceFactoryImpl
implements DataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceFactoryImpl.class);
    @Autowired(required=false)
    private List<DataSourceProvider> dataSourceProviders = new ArrayList<DataSourceProvider>();

    public DataSource getDataSource(ODataRequestContext requestContext, String entityType) throws ODataDataSourceException {
        for (DataSourceProvider dataSourceProvider : this.dataSourceProviders) {
            if (!dataSourceProvider.isSuitableFor(requestContext, entityType)) continue;
            return dataSourceProvider.getDataSource(requestContext);
        }
        LOG.error("No data source provider found for entity type '{}'", (Object)entityType);
        throw new ODataDataSourceException(String.format("No data source provider found for entity type '%s'", entityType));
    }

    public QueryOperationStrategy getStrategy(ODataRequestContext requestContext, QueryOperation operation, TargetType expectedODataEntityType) throws ODataException {
        String entityTypeName = this.getEntityTypeName(operation, requestContext.getEntityDataModel());
        if (entityTypeName != null) {
            for (DataSourceProvider dataSourceProvider : this.dataSourceProviders) {
                QueryOperationStrategy strategy;
                if (!dataSourceProvider.isSuitableFor(requestContext, entityTypeName) || (strategy = dataSourceProvider.getStrategy(requestContext, operation, expectedODataEntityType)) == null) continue;
                return strategy;
            }
        }
        LOG.error("No strategy found for operation: {}", (Object)operation);
        return null;
    }

    private String getEntityTypeName(QueryOperation operation, EntityDataModel entityDataModel) {
        EntitySet entitySet = entityDataModel.getEntityContainer().getEntitySet(operation.entitySetName());
        if (entitySet != null) {
            return entitySet.getTypeName();
        }
        Singleton singleton = entityDataModel.getEntityContainer().getSingleton(operation.entitySetName());
        if (singleton != null) {
            return singleton.getTypeName();
        }
        return null;
    }
}

