/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.processor;

import com.sdl.odata.api.ODataBadRequestException;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.ODataEdmException;
import com.sdl.odata.api.edm.model.Function;
import com.sdl.odata.api.edm.model.FunctionImport;
import com.sdl.odata.api.edm.model.Operation;
import com.sdl.odata.api.edm.model.Parameter;
import com.sdl.odata.api.edm.model.Schema;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.util.ParameterTypeUtil;
import com.sdl.odata.api.processor.ODataFunctionProcessor;
import com.sdl.odata.api.processor.ProcessorResult;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import java.lang.reflect.Field;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.Map;

@Component
public class ODataFunctionProcessorImpl
implements ODataFunctionProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ODataFunctionProcessorImpl.class);
    @Autowired
    private DataSourceFactory dataSourceFactory;

    public ProcessorResult doFunction(ODataRequestContext requestContext) throws ODataException {
        LOG.debug("Building and executing a function or function import");
        Operation operation = this.getFunctionOrFunctionImportOperation(requestContext);
        Object result = operation.doOperation(requestContext, this.dataSourceFactory);
        return result == null ? new ProcessorResult(ODataResponse.Status.NO_CONTENT) : new ProcessorResult(ODataResponse.Status.OK, result);
    }

    private Operation getFunctionOrFunctionImportOperation(ODataRequestContext requestContext) throws ODataException {
        Option functionCallName = ODataUriUtil.getFunctionCallName((ODataUri)requestContext.getUri());
        if (functionCallName.isDefined()) {
            String functionName = (String)functionCallName.get();
            int lastNamespaceIndex = functionName.lastIndexOf(46);
            String namespace = functionName.substring(0, lastNamespaceIndex);
            String simpleFunctionName = functionName.substring(lastNamespaceIndex + 1);
            Schema schema = requestContext.getEntityDataModel().getSchema(namespace);
            if (schema == null) {
                throw new IllegalArgumentException("Could not find schema with namespace: " + namespace);
            }
            Function function = schema.getFunction(simpleFunctionName);
            Operation functionOperation = (Operation)this.initializeFunctionObject(function);
            this.fillOperationParameters(functionOperation, (Option<scala.collection.immutable.Map<String, String>>)ODataUriUtil.getFunctionCallParameters((ODataUri)requestContext.getUri()), function.getParameters());
            return functionOperation;
        }
        Option functionImportCallName = ODataUriUtil.getFunctionImportCallName((ODataUri)requestContext.getUri());
        if (functionImportCallName.isDefined()) {
            String functionImportName = (String)functionImportCallName.get();
            FunctionImport functionImport = requestContext.getEntityDataModel().getEntityContainer().getFunctionImport(functionImportName);
            Operation functionImportOperation = (Operation)this.initializeFunctionObject(functionImport.getFunction());
            this.fillOperationParameters(functionImportOperation, (Option<scala.collection.immutable.Map<String, String>>)ODataUriUtil.getFunctionImportCallParameters((ODataUri)requestContext.getUri()), functionImport.getFunction().getParameters());
            return functionImportOperation;
        }
        throw new ODataBadRequestException("The target function or function import cannot be determined from URI");
    }

    private Object initializeFunctionObject(Function function) throws ODataEdmException {
        Object functionOperationObject;
        try {
            functionOperationObject = function.getJavaClass().newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new ODataEdmException("Error during initialization of OData Function instance: " + function.getName());
        }
        if (!(functionOperationObject instanceof Operation)) {
            throw new ODataEdmException("The initialized OData Function with name: " + function.getName() + " does not implement Operation interface");
        }
        return functionOperationObject;
    }

    private void fillOperationParameters(Object functionOperationObject, Option<scala.collection.immutable.Map<String, String>> functionCallParameters, Set<Parameter> parameters) throws ODataUnmarshallingException {
        if (functionCallParameters.isDefined() && !((scala.collection.immutable.Map)functionCallParameters.get()).isEmpty()) {
            java.util.Map parametersMap = JavaConversions.asJavaMap((Map)((Map)functionCallParameters.get()));
            for (Parameter parameter : parameters) {
                ParameterTypeUtil.setParameter((Object)functionOperationObject, (Field)parameter.getJavaField(), parametersMap.get(parameter.getName()));
            }
        }
    }
}

