/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client.property;

import com.sdl.odata.client.api.exception.ODataClientRuntimeException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUtils.class);

    private PropertyUtils() {
    }

    public static Integer getIntegerProperty(Properties properties, String key) {
        Integer value;
        String property = PropertyUtils.getStringProperty(properties, key);
        if (property == null) {
            return null;
        }
        try {
            value = Integer.parseInt(property);
        }
        catch (RuntimeException e) {
            throw new ODataClientRuntimeException("Unable to parse property. " + property, (Throwable)e);
        }
        return value;
    }

    public static Integer getIntegerProperty(Properties properties, String key, Integer defaultValue) {
        Integer property = PropertyUtils.getIntegerProperty(properties, key);
        return property == null ? defaultValue : property;
    }

    public static String getStringProperty(Properties properties, String key) {
        String property = properties.getProperty(key);
        return property != null && property.trim().isEmpty() ? null : property;
    }

    public static Long getLongProperty(String property) {
        if (property == null) {
            return null;
        }
        Long propertyLong = null;
        try {
            propertyLong = Long.valueOf(property);
        }
        catch (NumberFormatException e) {
            LOG.warn("Cannot convert string value into number", (Throwable)e);
        }
        return propertyLong;
    }
}

