/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client.marshall;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.ODataEdmException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.parser.EntitySetPath;
import com.sdl.odata.api.parser.ODataParser;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.RelativeUri;
import com.sdl.odata.api.parser.ResourcePath;
import com.sdl.odata.api.parser.ResourcePathUri;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.client.api.ODataClientQuery;
import com.sdl.odata.client.api.exception.ODataClientException;
import com.sdl.odata.client.api.exception.ODataClientParserException;
import com.sdl.odata.client.api.exception.ODataClientRuntimeException;
import com.sdl.odata.client.api.marshall.ODataEntityUnmarshaller;
import com.sdl.odata.edm.factory.annotations.AnnotationEntityDataModelFactory;
import com.sdl.odata.parser.ODataParserImpl;
import com.sdl.odata.unmarshaller.atom.ODataAtomParser;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class AtomEntityUnmarshaller
implements ODataEntityUnmarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(AtomEntityUnmarshaller.class);
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final Pattern PRIMITIVE_VALUE_RESPONSE_PATTERN = Pattern.compile("<metadata:value[^>]+>(.*)</metadata:value>");
    public static final Set<Class> PRIMITIVE_CLASSES = Stream.of(String.class, Integer.class, Long.class, Boolean.class, Double.class, Float.class).collect(Collectors.toSet());
    private String url;
    private EntityDataModel entityDataModel;

    public AtomEntityUnmarshaller(Iterable<Class<?>> edmEntityClasses, String url) {
        this.url = url;
        try {
            LOG.debug("Building entity data model...");
            this.entityDataModel = this.buildEntityDataModel(edmEntityClasses);
        }
        catch (ODataEdmException | RuntimeException e) {
            throw new ODataClientRuntimeException(MessageFormat.format("Caught exception {0}: {1} when building OData entity model", e.getClass().getSimpleName(), e.getMessage()), e);
        }
    }

    public Object unmarshallEntity(String odataServiceResponse, ODataClientQuery query) throws ODataClientException {
        LOG.debug("Unmarshalling entity for query: {}", (Object)query);
        try {
            if (PRIMITIVE_CLASSES.contains(query.getEntityType())) {
                return this.unmarshallPrimitives(odataServiceResponse);
            }
            return this.atomUnmarshall(odataServiceResponse, odataServiceResponse, query);
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataClientException((Throwable)e);
        }
    }

    private Object unmarshallPrimitives(String odataServiceResponse) {
        Matcher matcher = PRIMITIVE_VALUE_RESPONSE_PATTERN.matcher(odataServiceResponse);
        return matcher.find() ? matcher.group(1) : null;
    }

    public List<?> unmarshall(String odataServiceResponse, ODataClientQuery query) throws ODataClientException {
        LOG.debug("Unmarshalling entities for query: {}", (Object)query);
        try {
            ODataRequest request = this.buildODataRequestFromString(odataServiceResponse, query);
            ODataUri oDataUri = this.createODataUri(this.url, query.getEdmEntityName());
            ODataRequestContext requestContext = new ODataRequestContext(request, oDataUri, this.entityDataModel);
            return this.getODataAtomParser(requestContext).getODataEntities();
        }
        catch (ODataException | UnsupportedEncodingException e) {
            throw new ODataClientException(e);
        }
    }

    protected ODataAtomParser getODataAtomParser(ODataRequestContext requestContext) {
        return new ODataAtomParser(requestContext, (ODataParser)new ODataParserImpl());
    }

    public Object atomUnmarshall(String oDataEntityXml, String fullResponse, ODataClientQuery query) throws UnsupportedEncodingException, ODataClientException {
        Object unmarshalledEntity;
        ODataRequest request = this.buildODataRequestFromString(oDataEntityXml, query);
        ODataRequestContext requestContext = new ODataRequestContext(request, this.createODataUri(this.url, query.getEdmEntityName()), this.entityDataModel);
        try {
            unmarshalledEntity = this.getODataAtomParser(requestContext).getODataEntity();
        }
        catch (ODataException | RuntimeException e) {
            throw new ODataClientParserException(MessageFormat.format("Caught exception {0}: {1} when parsing response received from OData service", e.getClass().getSimpleName(), e.getMessage()), e, oDataEntityXml, fullResponse);
        }
        return unmarshalledEntity;
    }

    private ODataRequest buildODataRequestFromString(String content, ODataClientQuery query) throws UnsupportedEncodingException {
        ODataRequest.Builder requestBuilder = new ODataRequest.Builder();
        requestBuilder.setBodyText(content, StandardCharsets.UTF_8.name());
        requestBuilder.setUri(this.getTestServiceRoot(this.url, query.getEdmEntityName()));
        requestBuilder.setMethod(ODataRequest.Method.GET);
        return requestBuilder.build();
    }

    public EntityDataModel buildEntityDataModel(Iterable<Class<?>> edmEntityClasses) throws ODataEdmException {
        AnnotationEntityDataModelFactory factory = new AnnotationEntityDataModelFactory();
        return factory.addClasses(edmEntityClasses).buildEntityDataModel();
    }

    private String getTestServiceRoot(String serviceRoot, String entitySetName) {
        return this.createODataUri(serviceRoot, entitySetName).serviceRoot();
    }

    private ODataUri createODataUri(String serviceRoot, String entitySetName) {
        ArrayList queryOptions = new ArrayList();
        EntitySetPath entitySetPath = new EntitySetPath(entitySetName, Option.apply(null));
        ResourcePathUri resourcePathUri = new ResourcePathUri((ResourcePath)entitySetPath, ODataUriUtil.asScalaList(queryOptions));
        return new ODataUri(serviceRoot, (RelativeUri)resourcePathUri);
    }

    static {
        DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
    }
}

