/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client.marshall;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.ODataEdmException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.client.api.ODataClientQuery;
import com.sdl.odata.client.api.exception.ODataClientException;
import com.sdl.odata.client.api.exception.ODataClientRuntimeException;
import com.sdl.odata.client.api.marshall.ODataEntityMarshaller;
import com.sdl.odata.edm.factory.annotations.AnnotationEntityDataModelFactory;
import com.sdl.odata.parser.ODataParserImpl;
import com.sdl.odata.renderer.atom.AtomRenderer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomEntityMarshaller
implements ODataEntityMarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(AtomEntityMarshaller.class);
    private String url;
    private EntityDataModel entityDataModel;
    private AtomRenderer atomRenderer;

    public AtomEntityMarshaller(Iterable<Class<?>> edmEntityClasses, String url) {
        this.url = url;
        this.atomRenderer = new AtomRenderer();
        try {
            LOG.debug("Building entity data model...");
            this.entityDataModel = this.buildEntityDataModel(edmEntityClasses);
        }
        catch (ODataEdmException | RuntimeException e) {
            throw new ODataClientRuntimeException(MessageFormat.format("Caught exception {0}: {1} when building OData entity model", e.getClass().getSimpleName(), e.getMessage()), e);
        }
    }

    public String marshallEntity(Object oDataEntity, ODataClientQuery query) throws ODataClientException {
        String result;
        ODataResponse.Builder builder = new ODataResponse.Builder().setStatus(ODataResponse.Status.OK);
        try {
            String encodedServiceQueryUrl = this.url + "/" + URLEncoder.encode(query.getEdmEntityName(), StandardCharsets.UTF_8.name());
            ODataUri oDataServiceUri = new ODataParserImpl().parseUri(encodedServiceQueryUrl, this.entityDataModel);
            this.atomRenderer.render(this.buildODataPostContext(oDataServiceUri), oDataEntity, builder);
            result = builder.build().getBodyText(StandardCharsets.UTF_8.name());
        }
        catch (ODataException | UnsupportedEncodingException e) {
            throw new ODataClientException("Unable to marshall OData entity", e);
        }
        return result;
    }

    public String marshallEntities(List<?> oDataEntities, ODataClientQuery query) throws ODataClientException {
        return this.marshallEntity(oDataEntities, query);
    }

    private ODataRequestContext buildODataPostContext(ODataUri serviceUri) throws UnsupportedEncodingException, ODataEdmException {
        ODataRequest request = new ODataRequest.Builder().setUri(serviceUri.serviceRoot()).setBodyText("", StandardCharsets.UTF_8.name()).setAccept(new MediaType[]{MediaType.ATOM_XML}).setMethod(ODataRequest.Method.POST).build();
        return new ODataRequestContext(request, serviceUri, this.entityDataModel);
    }

    private EntityDataModel buildEntityDataModel(Iterable<Class<?>> edmEntityClasses) throws ODataEdmException {
        AnnotationEntityDataModelFactory factory = new AnnotationEntityDataModelFactory();
        return factory.addClasses(edmEntityClasses).buildEntityDataModel();
    }
}

