/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client.caller;

import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.client.ODataClientConstants;
import com.sdl.odata.client.api.caller.EndpointCaller;
import com.sdl.odata.client.api.exception.ODataClientException;
import com.sdl.odata.client.property.PropertyUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicEndpointCaller
implements EndpointCaller {
    private static final Logger LOG = LoggerFactory.getLogger(BasicEndpointCaller.class);
    private Integer timeout;
    private int proxyServerPort;
    private String proxyServerHostName;
    private int maxRetries;
    private String accessToken = "";

    public BasicEndpointCaller(Properties properties) {
        LOG.trace("Starting to inject client with properties");
        this.proxyServerHostName = PropertyUtils.getStringProperty(properties, "ServiceProxyHostName");
        this.timeout = PropertyUtils.getIntegerProperty(properties, "ConnectionTimeout", ODataClientConstants.DefaultValues.CLIENT_TIMEOUT_DEFAULT);
        Integer proxyPort = PropertyUtils.getIntegerProperty(properties, "ServiceProxyPort");
        this.proxyServerPort = proxyPort == null ? ODataClientConstants.DefaultValues.CLIENT_PROXY_PORT_DEFAULT : proxyPort;
        this.maxRetries = PropertyUtils.getIntegerProperty(properties, "ConnectionMaxRetries", 10);
        LOG.debug("Client is initialized with following parameters: host name: {}, timeout: {}, proxy port : {} ", new Object[]{this.proxyServerHostName, this.timeout, this.proxyServerPort});
    }

    public void setAccessToken(String token) {
        this.accessToken = token;
    }

    public String callEndpoint(URL url) throws ODataClientException {
        LOG.debug("Preparing the call endpoint for given url: {}", (Object)url);
        URLConnection conn = this.getConnection(url);
        return this.getResponse(conn, url);
    }

    private String sendRequest(URL urlToCall, String postRequestBody, String requestMethod, MediaType contentType, MediaType acceptType) throws ODataClientException {
        String result = null;
        FilterOutputStream dataOutputStream = null;
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        try {
            String inputLine;
            HttpURLConnection httpConnection = (HttpURLConnection)this.getConnection(urlToCall);
            httpConnection.setRequestMethod(requestMethod);
            httpConnection.setRequestProperty("Accept", acceptType.toString());
            httpConnection.setRequestProperty("Content-Type", contentType.toString());
            httpConnection.setRequestProperty("Content-Length", String.valueOf(postRequestBody.length()));
            httpConnection.setDoOutput(true);
            dataOutputStream = new DataOutputStream(httpConnection.getOutputStream());
            ((DataOutputStream)dataOutputStream).writeBytes(postRequestBody);
            ((DataOutputStream)dataOutputStream).flush();
            LOG.debug("POST request ended with {} status code", (Object)httpConnection.getResponseCode());
            inputStream = httpConnection.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder response = new StringBuilder();
            while ((inputLine = bufferedReader.readLine()) != null) {
                response.append(inputLine);
            }
            result = response.toString();
        }
        catch (IOException e) {
            throw new ODataClientException("Unable to make POST request to OData service", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOG.error("IOException when closing InputStream", (Throwable)e);
                    }
                }
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                throw new ODataClientException("Unable to close stream while POST request to OData client", (Throwable)e);
            }
        }
        return result;
    }

    public String doPostEntity(URL urlToCall, String postRequestBody, MediaType contentType, MediaType acceptType) throws ODataClientException {
        return this.sendRequest(urlToCall, postRequestBody, "POST", contentType, acceptType);
    }

    public String doPutEntity(URL urlToCall, String putRequestBody, MediaType type) throws ODataClientException {
        return this.sendRequest(urlToCall, putRequestBody, "PUT", type, type);
    }

    private URLConnection getConnection(URL url) throws ODataClientException {
        URLConnection urlConnection;
        try {
            if (this.proxyServerHostName == null) {
                urlConnection = url.openConnection();
            } else {
                InetSocketAddress proxySocketAddress = new InetSocketAddress(this.proxyServerHostName, this.proxyServerPort);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, proxySocketAddress);
                urlConnection = url.openConnection(proxy);
            }
            if (this.timeout != null) {
                urlConnection.setConnectTimeout(this.timeout);
                urlConnection.setReadTimeout(this.timeout);
            }
        }
        catch (IOException e) {
            throw this.processedException(e, url, " when getting connection to");
        }
        if (this.accessToken != null && !this.accessToken.isEmpty()) {
            urlConnection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
        }
        return urlConnection;
    }

    private String getResponse(URLConnection urlConnection, URL url) throws ODataClientException {
        urlConnection.setRequestProperty("Accept", "application/xml");
        StringBuilder response = new StringBuilder();
        InputStream inputStream = null;
        BufferedReader buf = null;
        try {
            String line;
            inputStream = this.getInputStream(urlConnection);
            buf = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = buf.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException | RuntimeException e) {
            throw this.processedException(e, url, " when accessing");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error("IOException when closing InputStream", (Throwable)e);
                }
            }
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (IOException e) {
                    LOG.error("IOException when closing BufferedReader", (Throwable)e);
                }
            }
        }
        return response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(URLConnection urlConnection) throws IOException, ODataClientException {
        int retryCounter = 1;
        while (retryCounter <= this.maxRetries) {
            try {
                BasicEndpointCaller basicEndpointCaller = this;
                synchronized (basicEndpointCaller) {
                    return urlConnection.getInputStream();
                }
            }
            catch (IOException | RuntimeException e) {
                if (e.getMessage().startsWith("Address already in use")) {
                    LOG.info("Error getting connection, will try again. Retry count = " + retryCounter++ + "," + "Maximum retries = " + this.maxRetries);
                    continue;
                }
                LOG.error("Exception when getting Input Stream", (Throwable)e);
                throw e;
            }
        }
        throw new ODataClientException("Could not get data ever after maximum retries");
    }

    private ODataClientException processedException(Throwable e, URL url, String message) throws ODataClientException {
        LOG.error("Exception when getting data from service endpoint", e);
        String proxyInfo = "";
        if (this.proxyServerHostName != null) {
            proxyInfo = " (proxy='" + this.proxyServerHostName + '\'' + " port=" + '\'' + this.proxyServerPort + '\'' + ")";
        }
        return new ODataClientException("Caught '" + e.getClass().getSimpleName() + (e.getMessage() != null ? ":" + e.getMessage() : "") + '\'' + message + " URL " + '\'' + url.toString() + '\'' + proxyInfo, e);
    }
}

