/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client;

import com.sdl.odata.client.AbstractODataFunctionClientQuery;
import com.sdl.odata.client.api.ODataClientQuery;
import java.util.LinkedHashMap;
import java.util.Map;

public class FunctionImportClientQuery
extends AbstractODataFunctionClientQuery {
    public FunctionImportClientQuery(Builder builder) {
        super(builder.entityType, builder.functionName, builder.functionParameterMap);
    }

    public String getQuery() {
        return this.appendFunctionPath() + this.generateFunctionParameters();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionImportClientQuery that = (FunctionImportClientQuery)o;
        if (!this.getEntityType().equals(that.getEntityType())) {
            return false;
        }
        if (!this.getFunctionName().equals(that.getFunctionName())) {
            return false;
        }
        return !(this.getFunctionParameterMap() != null ? !this.getFunctionParameterMap().equals(that.getFunctionParameterMap()) : that.getFunctionParameterMap() != null);
    }

    public int hashCode() {
        int result = this.getEntityType().hashCode();
        result = 31 * result + this.getFunctionName().hashCode();
        result = 31 * result + (this.getFunctionParameterMap() != null ? this.getFunctionParameterMap().hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("ODataClientQuery[%s]", this.getQuery());
    }

    public static class Builder {
        private Class<?> entityType;
        private String functionName;
        private Map<String, String> functionParameterMap;

        public Builder withEntityType(Class<?> clazz) {
            this.entityType = clazz;
            return this;
        }

        public Builder withFunctionParameter(String functionParameterName, String functionParameterValue) {
            if (this.functionParameterMap == null) {
                this.functionParameterMap = new LinkedHashMap<String, String>();
            }
            this.functionParameterMap.put(functionParameterName, functionParameterValue);
            return this;
        }

        public Builder withFunctionName(String name) {
            this.functionName = name;
            return this;
        }

        public ODataClientQuery build() {
            return new FunctionImportClientQuery(this);
        }
    }
}

