/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client;

import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.client.BasicODataClientQuery;
import com.sdl.odata.client.api.ODataActionClientQuery;
import com.sdl.odata.client.api.ODataClient;
import com.sdl.odata.client.api.ODataClientComponentsProvider;
import com.sdl.odata.client.api.ODataClientQuery;
import com.sdl.odata.client.api.exception.ODataClientException;
import com.sdl.odata.client.api.exception.ODataClientRuntimeException;
import com.sdl.odata.client.api.exception.ODataNotImplementedException;
import com.sdl.odata.client.api.model.ODataIdAwareEntity;
import com.sdl.odata.client.marshall.AtomEntityUnmarshaller;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultODataClient
implements ODataClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultODataClient.class);
    private ODataClientComponentsProvider componentsProvider;
    private boolean encodeURL = true;

    public void configure(ODataClientComponentsProvider clientComponentsProvider) {
        this.componentsProvider = clientComponentsProvider;
    }

    public void encodeURL(boolean encode) {
        this.encodeURL = encode;
    }

    public Object getEntity(ODataClientQuery query) {
        LOG.debug("Getting entity for query {}", (Object)query);
        String oDataResponse = this.getODataResponse(query);
        try {
            return this.componentsProvider.getUnmarshaller().unmarshallEntity(oDataResponse, query);
        }
        catch (ODataClientException oce) {
            throw new ODataClientRuntimeException(MessageFormat.format("Unable unmarshall OData entity service response: \"{0}\"", oDataResponse), (Throwable)oce);
        }
    }

    public Object performAction(ODataActionClientQuery actionQuery) {
        try {
            String oDataResponse = this.getComponentsProvider().getEndpointCaller().doPostEntity(this.buildURL((ODataClientQuery)actionQuery), actionQuery.getActionRequestBody(), MediaType.JSON, MediaType.ATOM_XML);
            if (AtomEntityUnmarshaller.PRIMITIVE_CLASSES.contains(actionQuery.getEntityType())) {
                return this.componentsProvider.getUnmarshaller().unmarshallEntity(oDataResponse, (ODataClientQuery)actionQuery);
            }
            return this.componentsProvider.getUnmarshaller().unmarshall(oDataResponse, (ODataClientQuery)new BasicODataClientQuery.Builder().withEntityType(actionQuery.getEntityType()).build());
        }
        catch (ODataClientException e) {
            throw new ODataClientRuntimeException("Unable to perform action", (Throwable)e);
        }
    }

    public ODataClientComponentsProvider getComponentsProvider() {
        return this.componentsProvider;
    }

    public List<?> getEntities(ODataClientQuery query) {
        LOG.debug("Getting entities for query {}", (Object)query);
        String oDataResponse = this.getODataResponse(query);
        try {
            return this.componentsProvider.getUnmarshaller().unmarshall(oDataResponse, query);
        }
        catch (ODataClientException e) {
            throw new ODataClientRuntimeException(MessageFormat.format("Unable unmarshall OData entities service response: \"{0}\"", oDataResponse), (Throwable)e);
        }
    }

    private URL buildURL(ODataClientQuery query) {
        String builtQuery = query.getQuery();
        try {
            if (this.encodeURL) {
                LOG.debug("Encoding input query : " + query);
                builtQuery = URLEncoder.encode(builtQuery, "UTF-8");
                LOG.debug("Encoded query : " + query);
            }
            return new URL(this.componentsProvider.getWebServiceUrl().toString() + "/" + builtQuery);
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new IllegalArgumentException(MessageFormat.format("MalformedURLException, cannot form a valid URL for endpoint \"{0}\" and service query \"/{1}\"", this.componentsProvider.getWebServiceUrl().toString(), builtQuery), e);
        }
    }

    private String getODataResponse(ODataClientQuery query) {
        try {
            return this.componentsProvider.getEndpointCaller().callEndpoint(this.buildURL(query));
        }
        catch (ODataClientException e) {
            throw new ODataClientRuntimeException(MessageFormat.format("Unable to call OData service for \"{0}\" URL and service query \"/{1}\"", this.componentsProvider.getWebServiceUrl().toString(), query.getQuery()), (Throwable)e);
        }
    }

    public Object getMetaData(ODataClientQuery builder) {
        throw new ODataNotImplementedException();
    }

    public Iterable<Object> getLinks(ODataClientQuery builder) {
        throw new ODataNotImplementedException();
    }

    public Iterable<Object> getCollections(ODataClientQuery builder) {
        throw new ODataNotImplementedException();
    }

    public Object createEntity(Object entity) {
        BasicODataClientQuery query = this.buildQueryForEntity(entity);
        String entitySetName = query.getEdmEntityName();
        try {
            URL endpointUrl = new URL(this.getUrlToCall(entitySetName, false, null));
            String marshalledEntity = this.componentsProvider.getMarshaller().marshallEntity(entity, (ODataClientQuery)query);
            String createdEntity = this.componentsProvider.getEndpointCaller().doPostEntity(endpointUrl, marshalledEntity, MediaType.ATOM_XML, MediaType.ATOM_XML);
            return this.componentsProvider.getUnmarshaller().unmarshallEntity(createdEntity, (ODataClientQuery)query);
        }
        catch (ODataClientException e) {
            throw this.formFailedRequestException(e, entitySetName);
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw this.formFailedUrlFormingException(e, entitySetName);
        }
    }

    public Object updateEntity(ODataIdAwareEntity entity) {
        BasicODataClientQuery query = this.buildQueryForEntity(entity);
        String entitySetName = query.getEdmEntityName();
        try {
            URL endpointUrl = new URL(this.getUrlToCall(entitySetName, true, entity.getId()));
            String marshalledEntity = this.componentsProvider.getMarshaller().marshallEntity((Object)entity, (ODataClientQuery)query);
            String createdEntity = this.componentsProvider.getEndpointCaller().doPutEntity(endpointUrl, marshalledEntity, MediaType.ATOM_XML);
            return this.componentsProvider.getUnmarshaller().unmarshallEntity(createdEntity, (ODataClientQuery)query);
        }
        catch (ODataClientException e) {
            throw this.formFailedRequestException(e, entitySetName);
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw this.formFailedUrlFormingException(e, entitySetName);
        }
    }

    private String getUrlToCall(String entitySetName, boolean includeId, String id) throws UnsupportedEncodingException {
        return this.componentsProvider.getWebServiceUrl().toString() + "/" + URLEncoder.encode(entitySetName, "UTF-8") + (includeId ? "('" + id + "')" : "");
    }

    private BasicODataClientQuery buildQueryForEntity(Object entity) {
        return new BasicODataClientQuery.Builder().withEntityType(entity.getClass()).build();
    }

    private ODataClientRuntimeException formFailedRequestException(Throwable e, String entitySetName) {
        return new ODataClientRuntimeException(MessageFormat.format("Unable to make POST request to OData service for \"{0}\" URL and service query \"/{1}\"", this.componentsProvider.getWebServiceUrl().toString(), entitySetName), e);
    }

    private ODataClientRuntimeException formFailedUrlFormingException(Throwable e, String entitySetName) {
        return new ODataClientRuntimeException(MessageFormat.format("Unable to form POST URL for OData service with \"{0}\" URL and service query \"/{1}\"", this.componentsProvider.getWebServiceUrl().toString(), entitySetName), e);
    }
}

