/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client;

import java.util.Map;
import java.util.Properties;

public class ClientPropertiesBuilder {
    private Properties properties = new Properties();

    public ClientPropertiesBuilder() {
    }

    public ClientPropertiesBuilder(Map<String, String> configValues) {
        String clientServiceUriValue = configValues.get("ServiceUri");
        String clientConnectionTimeout = configValues.get("ConnectionTimeout");
        String clientServiceProxyHostName = configValues.get("ServiceProxyHostName");
        String clientServiceProxyPort = configValues.get("ServiceProxyPort");
        String clientCacheEnabled = configValues.get("CacheEnabled");
        String clientCacheExpirationDuration = configValues.get("CacheExpirationDuration");
        if (clientServiceUriValue != null) {
            this.properties.setProperty("ServiceUri", clientServiceUriValue);
        }
        if (clientConnectionTimeout != null) {
            this.properties.setProperty("ConnectionTimeout", clientConnectionTimeout);
        }
        if (clientServiceProxyHostName != null) {
            this.properties.setProperty("ServiceProxyHostName", clientServiceProxyHostName);
        }
        if (clientServiceProxyPort != null) {
            this.properties.setProperty("ServiceProxyPort", clientServiceProxyPort);
        }
        if (clientCacheEnabled != null) {
            this.properties.setProperty("CacheEnabled", clientCacheEnabled);
        }
        if (clientCacheExpirationDuration != null) {
            this.properties.setProperty("CacheExpirationDuration", clientCacheExpirationDuration);
        }
    }

    public Properties build() {
        return this.properties;
    }

    public ClientPropertiesBuilder withServiceUri(String serviceUri) {
        this.properties.setProperty("ServiceUri", serviceUri);
        return this;
    }

    public ClientPropertiesBuilder withClientTimeout(Integer timeout) {
        this.properties.setProperty("ConnectionTimeout", timeout.toString());
        return this;
    }

    public ClientPropertiesBuilder withProxyHostName(String proxyHostName) {
        this.properties.setProperty("ServiceProxyHostName", proxyHostName);
        return this;
    }

    public ClientPropertiesBuilder withProxyPort(Integer proxyPortNumber) {
        this.properties.setProperty("ServiceProxyPort", proxyPortNumber.toString());
        return this;
    }

    public ClientPropertiesBuilder withCaching(boolean cacheEnabled) {
        this.properties.setProperty("CacheEnabled", Boolean.toString(cacheEnabled));
        return this;
    }

    public ClientPropertiesBuilder withCacheExpirationDuration(Long cacheExpirationTime) {
        this.properties.setProperty("CacheExpirationDuration", cacheExpirationTime.toString());
        return this;
    }
}

