/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client;

import com.sdl.odata.client.AbstractODataFunctionClientQuery;
import com.sdl.odata.client.api.ODataClientQuery;
import java.util.LinkedHashMap;
import java.util.Map;

public class BoundFunctionClientQuery
extends AbstractODataFunctionClientQuery {
    private String boundEntityName;
    private String functionNameSpace;

    public BoundFunctionClientQuery(Builder builder) {
        super(builder.entityType, builder.functionName, builder.functionParameterMap);
        BoundFunctionClientQuery.checkNotNull(builder.boundEntityName, "Bound Entity Name shouldn't be null");
        this.boundEntityName = builder.boundEntityName;
        this.functionNameSpace = builder.functionNameSpace;
    }

    public String getQuery() {
        return this.boundEntityName + "/" + this.functionNameSpace + "." + this.appendFunctionPath() + this.generateFunctionParameters();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundFunctionClientQuery that = (BoundFunctionClientQuery)o;
        if (!this.boundEntityName.equals(that.boundEntityName)) {
            return false;
        }
        if (!this.getFunctionName().equals(that.getFunctionName())) {
            return false;
        }
        if (!this.functionNameSpace.equals(that.functionNameSpace)) {
            return false;
        }
        return !(this.getFunctionParameterMap() != null ? !this.getFunctionParameterMap().equals(that.getFunctionParameterMap()) : that.getFunctionParameterMap() != null);
    }

    public int hashCode() {
        int result = this.boundEntityName.hashCode();
        result = 31 * result + this.functionNameSpace.hashCode();
        result = 31 * result + this.getFunctionName().hashCode();
        result = 31 * result + this.getFunctionParameterMap().hashCode();
        return result;
    }

    public String toString() {
        return String.format("ODataClientQuery[%s]", this.getQuery());
    }

    public static class Builder {
        private Class<?> entityType;
        private String functionName;
        private Map<String, String> functionParameterMap;
        private String boundEntityName;
        private String functionNameSpace;

        public Builder withBoundEntityName(String boundEntity) {
            this.boundEntityName = boundEntity;
            return this;
        }

        public Builder withNameSpace(String nameSpace) {
            this.functionNameSpace = nameSpace;
            return this;
        }

        public Builder withEntityType(Class<?> clazz) {
            this.entityType = clazz;
            return this;
        }

        public Builder withFunctionParameter(String functionParameterName, String functionParameterValue) {
            if (this.functionParameterMap == null) {
                this.functionParameterMap = new LinkedHashMap<String, String>();
            }
            this.functionParameterMap.put(functionParameterName, functionParameterValue);
            return this;
        }

        public Builder withFunctionName(String name) {
            this.functionName = name;
            return this;
        }

        public ODataClientQuery build() {
            return new BoundFunctionClientQuery(this);
        }
    }
}

