/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client;

import com.sdl.odata.client.AbstractODataClientQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BasicODataClientQuery
extends AbstractODataClientQuery {
    private Map<String, String> filterMap;
    private List<String> expandParameters;
    private static final String EXPAND_PREFIX = "$expand=";
    private static final String FILTER_PREFIX = "$filter=";

    public BasicODataClientQuery(Builder builder) {
        if (builder.entityType == null) {
            throw new IllegalArgumentException("EntityType shouldn't be null");
        }
        this.setEntityType(builder.entityType);
        this.filterMap = builder.filteringMap;
        this.expandParameters = builder.expandParameters;
    }

    public String getQuery() {
        StringBuilder query = new StringBuilder();
        query.append(this.getEdmEntityName());
        query.append((CharSequence)this.generateParameters());
        return query.toString();
    }

    private StringBuilder generateParameters() {
        StringBuilder parameters = new StringBuilder();
        if (this.filterMap == null && this.expandParameters == null) {
            return parameters;
        }
        parameters.append('?');
        int filterParameterCounter = 0;
        if (this.filterMap != null && !this.filterMap.isEmpty()) {
            parameters.append(FILTER_PREFIX);
            for (Map.Entry<String, String> filterEntry : this.filterMap.entrySet()) {
                parameters.append(String.format("%s eq '%s'", filterEntry.getKey(), filterEntry.getValue()));
                if (++filterParameterCounter >= this.filterMap.size()) continue;
                parameters.append(" and ");
            }
            if (this.expandParameters != null) {
                parameters.append("&");
            }
        }
        if (this.expandParameters != null) {
            parameters.append(EXPAND_PREFIX);
            Iterator<String> iterator = this.expandParameters.iterator();
            parameters.append(String.format("%s", iterator.next()));
            while (iterator.hasNext()) {
                parameters.append(String.format(",%s", iterator.next()));
            }
        }
        return parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicODataClientQuery that = (BasicODataClientQuery)o;
        if (!this.getEntityType().equals(that.getEntityType())) {
            return false;
        }
        if (this.expandParameters == null ? that.expandParameters != null : !this.expandParameters.equals(that.expandParameters)) {
            return false;
        }
        return !(this.filterMap == null ? that.expandParameters != null : !this.filterMap.equals(that.filterMap));
    }

    public int hashCode() {
        int result = this.getEntityType().hashCode();
        result = 31 * result + (this.filterMap == null ? 0 : this.filterMap.hashCode());
        result = 31 * result + (this.expandParameters == null ? 0 : this.expandParameters.hashCode());
        return result;
    }

    public String toString() {
        return String.format("ODataClientQuery[%s]", this.getQuery());
    }

    public static class Builder {
        private Class<?> entityType;
        private List<String> expandParameters;
        private Map<String, String> filteringMap;

        public Builder withEntityType(Class<?> clazz) {
            this.entityType = clazz;
            return this;
        }

        public Builder withFilterMap(String filterParameter, String filterValue) {
            if (this.filteringMap == null) {
                this.filteringMap = new LinkedHashMap<String, String>();
            }
            this.filteringMap.put(filterParameter, filterValue);
            return this;
        }

        public Builder withExpandParameters(String expandParameter) {
            if (this.expandParameters == null) {
                this.expandParameters = new ArrayList<String>();
            }
            this.expandParameters.add(expandParameter);
            return this;
        }

        public BasicODataClientQuery build() {
            return new BasicODataClientQuery(this);
        }
    }
}

