/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client;

import com.sdl.odata.client.AbstractODataClientQuery;
import com.sdl.odata.client.api.ODataActionClientQuery;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class ActionImportClientQuery
extends AbstractODataClientQuery
implements ODataActionClientQuery {
    private String actionName;
    private String actionRequestBody;

    private ActionImportClientQuery(Builder builder) {
        ActionImportClientQuery.checkNotNull(builder.returnType, "Action return type should not be null");
        ActionImportClientQuery.checkNotNull(builder.actionName, "Action name should not be null");
        this.setEntityType(builder.returnType);
        this.actionName = builder.actionName;
        this.actionRequestBody = builder.actionParameterMap == null || builder.actionParameterMap.isEmpty() ? "" : "{" + builder.actionParameterMap.entrySet().stream().map(entry -> String.format("\"%s\":%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(",")) + "}";
    }

    public String getActionRequestBody() {
        return this.actionRequestBody;
    }

    public String getQuery() {
        return this.actionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionImportClientQuery that = (ActionImportClientQuery)o;
        return this.getEntityType().equals(that.getEntityType()) && this.actionName.equals(that.actionName) && this.actionRequestBody.equals(that.actionRequestBody);
    }

    public int hashCode() {
        int result = this.getEntityType().hashCode();
        result = 31 * result + this.actionName.hashCode();
        result = 31 * result + this.actionRequestBody.hashCode();
        return result;
    }

    public String toString() {
        return String.format("ActionImportClientQuery[%s]", this.getQuery());
    }

    public static class Builder {
        private Class<?> returnType;
        private String actionName;
        private Map<String, String> actionParameterMap;

        public Builder withReturnType(Class<?> clazz) {
            this.returnType = clazz;
            return this;
        }

        public Builder withActionParameter(String actionParameterName, String actionParameterValue) {
            if (this.actionParameterMap == null) {
                this.actionParameterMap = new LinkedHashMap<String, String>();
            }
            this.actionParameterMap.put(actionParameterName, actionParameterValue);
            return this;
        }

        public Builder withActionName(String name) {
            this.actionName = name;
            return this;
        }

        public ODataActionClientQuery build() {
            return new ActionImportClientQuery(this);
        }
    }
}

