/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client;

import com.sdl.odata.client.AbstractODataClientQuery;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractODataFunctionClientQuery
extends AbstractODataClientQuery {
    private String functionName;
    private Map<String, String> functionParameterMap;

    public AbstractODataFunctionClientQuery(Class<?> entityType, String functionName, Map<String, String> functionParameterMap) {
        AbstractODataFunctionClientQuery.checkNotNull(functionName, "FunctionName shouldn't be null");
        AbstractODataFunctionClientQuery.checkNotNull(entityType, "EntityType shouldn't be null");
        this.setEntityType(entityType);
        this.functionName = functionName;
        this.functionParameterMap = functionParameterMap;
    }

    protected String appendFunctionPath() {
        return this.functionName;
    }

    protected String generateFunctionParameters() {
        if (this.functionParameterMap == null || this.functionParameterMap.isEmpty()) {
            return "";
        }
        return "(" + this.functionParameterMap.entrySet().stream().filter(entity -> entity.getValue() != null && !((String)entity.getValue()).isEmpty()).map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(",")) + ")";
    }

    protected String getFunctionName() {
        return this.functionName;
    }

    protected Map<String, String> getFunctionParameterMap() {
        return this.functionParameterMap;
    }
}

