/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client;

import com.sdl.odata.api.edm.annotations.EdmEntitySet;
import com.sdl.odata.api.edm.annotations.EdmSingleton;
import com.sdl.odata.client.api.ODataClientQuery;
import com.sdl.odata.client.api.exception.ODataClientRuntimeException;
import com.sdl.odata.util.ReferenceUtil;
import com.sdl.odata.util.edm.EntityDataModelUtil;

public abstract class AbstractODataClientQuery
implements ODataClientQuery {
    public static final int HASH = 31;
    private Class<?> entityType;

    public Class<?> getEntityType() {
        return this.entityType;
    }

    protected void setEntityType(Class<?> entityType) {
        this.entityType = entityType;
    }

    public String getEdmEntityName() {
        EdmEntitySet edmEntitySet = this.entityType.getAnnotation(EdmEntitySet.class);
        if (edmEntitySet != null) {
            String entitySetName = edmEntitySet.name();
            if (ReferenceUtil.isNullOrEmpty((String)entitySetName) && ReferenceUtil.isNullOrEmpty((String)(entitySetName = edmEntitySet.value()))) {
                entitySetName = EntityDataModelUtil.pluralize((String)this.entityType.getSimpleName());
            }
            return entitySetName;
        }
        EdmSingleton singleton = this.entityType.getAnnotation(EdmSingleton.class);
        if (singleton == null) {
            throw new ODataClientRuntimeException("There is no an odata endpoint for provided class. @EdmEntitySet or @EdmSingleton annotation is not present on this type");
        }
        String entityName = this.entityType.getSimpleName();
        if (ReferenceUtil.isNullOrEmpty((String)entityName)) {
            entityName = singleton.value();
        }
        return entityName;
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }
}

