/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.client;

import com.sdl.odata.client.api.ODataClientComponentsProvider;
import com.sdl.odata.client.api.caller.EndpointCaller;
import com.sdl.odata.client.api.exception.ODataClientRuntimeException;
import com.sdl.odata.client.api.marshall.ODataEntityMarshaller;
import com.sdl.odata.client.api.marshall.ODataEntityUnmarshaller;
import com.sdl.odata.client.caller.BasicEndpointCaller;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractODataClientComponentsProvider
implements ODataClientComponentsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractODataClientComponentsProvider.class);
    private URL webServiceUri;
    private EndpointCaller endpointCaller;
    private ODataEntityUnmarshaller unmarshaller;
    private ODataEntityMarshaller marshaller;

    public AbstractODataClientComponentsProvider(Iterable<String> edmEntityClasses, Properties properties, String token) {
        this.webServiceUri = this.getServiceUri(properties);
        this.endpointCaller = new BasicEndpointCaller(properties);
        this.endpointCaller.setAccessToken(token);
        this.initComponetsProvider(edmEntityClasses);
    }

    protected void setEntityMarshaller(ODataEntityMarshaller entityMarshaller) {
        this.marshaller = entityMarshaller;
    }

    protected void setEntityUnmarshaller(ODataEntityUnmarshaller entityUnmarshaller) {
        this.unmarshaller = entityUnmarshaller;
    }

    public EndpointCaller getEndpointCaller() {
        return this.endpointCaller;
    }

    public ODataEntityUnmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public ODataEntityMarshaller getMarshaller() {
        return this.marshaller;
    }

    public URL getWebServiceUrl() {
        return this.webServiceUri;
    }

    protected abstract void initComponetsProvider(Iterable<String> var1);

    protected URL getServiceUri(Properties properties) {
        String uriString = properties.getProperty("ServiceUri");
        if (uriString == null || uriString.trim().isEmpty()) {
            throw new ODataClientRuntimeException("Error no service URI property value has been defined (with key of 'ServiceUri')");
        }
        try {
            URI uri = new URI(uriString);
            return new URL(uri.toString());
        }
        catch (RuntimeException | MalformedURLException | URISyntaxException e) {
            throw AbstractODataClientComponentsProvider.processedServiceUriPropertyException(e, uriString, "ServiceUri");
        }
    }

    private static ODataClientRuntimeException processedServiceUriPropertyException(Throwable e, String value, String key) {
        return AbstractODataClientComponentsProvider.processedPropertyException(e, " OData Service URI is invalid,", value, key);
    }

    private static ODataClientRuntimeException processedPropertyException(Throwable e, String message, String value, String key) {
        String errorMessage = "Caught '" + e.getClass().getSimpleName() + (e.getMessage() != null ? ":" + e.getMessage() : "") + "'" + message + " key='" + key + "' and value= '" + value + "'";
        return new ODataClientRuntimeException(errorMessage);
    }

    protected Iterable<Class<?>> getClassesForNames(Iterable<String> classNames) {
        ArrayList edmEntityClasses = new ArrayList();
        for (String className : classNames) {
            try {
                edmEntityClasses.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                LOG.debug("Provided class not found", (Throwable)e);
            }
        }
        return edmEntityClasses;
    }
}

