/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.service;

import com.sdl.odata.api.ODataUnsupportedMediaTypeException;
import com.sdl.odata.api.parser.BatchUri$;
import com.sdl.odata.api.parser.EntityUri;
import com.sdl.odata.api.parser.FormatOption;
import com.sdl.odata.api.parser.MetadataUri;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil$;
import com.sdl.odata.api.parser.RelativeUri;
import com.sdl.odata.api.parser.ResourcePathUri;
import com.sdl.odata.api.parser.ServiceRootUri;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class ODataRequestContextUtil$ {
    public static ODataRequestContextUtil$ MODULE$;
    private final List<MediaType> supportedMediaTypes;
    private final List<MediaType> supportedMetadataMediaTypes;

    static {
        new ODataRequestContextUtil$();
    }

    private List<MediaType> supportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    private List<MediaType> supportedMetadataMediaTypes() {
        return this.supportedMetadataMediaTypes;
    }

    public void checkSupportedType(ODataRequestContext requestContext) {
        if (this.isMediaTypeSpecified(requestContext) && !this.isMediaTypesSupported(requestContext)) {
            throw new ODataUnsupportedMediaTypeException("Unsupported media type");
        }
    }

    public boolean isMediaTypeSpecified(ODataRequestContext requestContext) {
        return requestContext.getRequest().getAccept().size() > 0 || ODataUriUtil$.MODULE$.getFormatOption(requestContext.getUri()).isDefined();
    }

    public boolean isMediaTypesSupported(ODataRequestContext context) {
        RelativeUri relativeUri;
        RelativeUri relativeUri2;
        RelativeUri relativeUri3;
        RelativeUri relativeUri4;
        boolean bl;
        RelativeUri relativeUri5;
        ODataUri oDataUri = context.getUri();
        if (oDataUri != null && (relativeUri5 = oDataUri.relativeUri()) instanceof MetadataUri) {
            bl = this.isMetadataMediaTypesSupported(context.getRequest()) || this.isMetadataMediaTypesSupported(context.getUri());
        } else if (oDataUri != null && (relativeUri4 = oDataUri.relativeUri()) instanceof ServiceRootUri) {
            bl = this.isMediaTypesSupported(context.getRequest()) || this.isMediaTypesSupported(context.getUri());
        } else if (oDataUri != null && (relativeUri3 = oDataUri.relativeUri()) instanceof EntityUri) {
            bl = this.isMediaTypesSupported(context.getRequest()) || this.isMediaTypesSupported(context.getUri());
        } else if (oDataUri != null && (relativeUri2 = oDataUri.relativeUri()) instanceof ResourcePathUri) {
            bl = this.isMediaTypesSupported(context.getRequest()) || this.isMediaTypesSupported(context.getUri());
        } else if (oDataUri != null && BatchUri$.MODULE$.equals(relativeUri = oDataUri.relativeUri())) {
            bl = this.isMediaTypesSupported(context.getRequest()) || this.isMediaTypesSupported(context.getUri());
        } else {
            throw new UnsupportedOperationException(new StringBuilder(29).append("No implementation for ").append(context).append(".getUri").toString());
        }
        return bl;
    }

    public boolean isMediaTypesSupported(ODataRequest request) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.getAccept()).asScala()).exists((Function1 & Serializable & scala.Serializable)mediaType -> BoxesRunTime.boxToBoolean((boolean)ODataRequestContextUtil$.$anonfun$isMediaTypesSupported$1(mediaType)));
    }

    public boolean isMediaTypesSupported(ODataUri oDataUri) {
        boolean bl;
        Option<FormatOption> option = ODataUriUtil$.MODULE$.getFormatOption(oDataUri);
        if (option instanceof Some) {
            Some some = (Some)option;
            FormatOption formatOpt = (FormatOption)some.value();
            bl = this.supportedMediaTypes().contains((Object)formatOpt.mediaType());
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isMetadataMediaTypesSupported(ODataRequest request) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.getAccept()).asScala()).exists((Function1 & Serializable & scala.Serializable)mediaType -> BoxesRunTime.boxToBoolean((boolean)ODataRequestContextUtil$.$anonfun$isMetadataMediaTypesSupported$1(mediaType)));
    }

    public boolean isMetadataMediaTypesSupported(ODataUri oDataUri) {
        boolean bl;
        Option<FormatOption> option = ODataUriUtil$.MODULE$.getFormatOption(oDataUri);
        if (option instanceof Some) {
            Some some = (Some)option;
            FormatOption formatOpt = (FormatOption)some.value();
            bl = this.supportedMetadataMediaTypes().contains((Object)formatOpt.mediaType());
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isReadOperation(ODataRequestContext context) {
        ODataRequest.Method method = context.getRequest().getMethod();
        boolean bl = ((Object)((Object)ODataRequest.Method.GET)).equals((Object)method);
        return bl;
    }

    public boolean isWriteOperation(ODataRequestContext context) {
        ODataRequest.Method method = context.getRequest().getMethod();
        boolean bl = ((Object)((Object)ODataRequest.Method.POST)).equals((Object)method) ? true : (((Object)((Object)ODataRequest.Method.PATCH)).equals((Object)method) ? true : (((Object)((Object)ODataRequest.Method.PUT)).equals((Object)method) ? true : ((Object)((Object)ODataRequest.Method.DELETE)).equals((Object)method)));
        return bl;
    }

    public boolean isBatchOperation(ODataRequestContext context) {
        RelativeUri relativeUri = context.getUri().relativeUri();
        boolean bl = relativeUri == BatchUri$.MODULE$;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isMediaTypesSupported$1(MediaType mediaType) {
        return MODULE$.supportedMediaTypes().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.matches(mediaType)));
    }

    public static final /* synthetic */ boolean $anonfun$isMetadataMediaTypesSupported$1(MediaType mediaType) {
        return MODULE$.supportedMetadataMediaTypes().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.matches(mediaType)));
    }

    private ODataRequestContextUtil$() {
        MODULE$ = this;
        this.supportedMediaTypes = new .colon.colon((Object)MediaType.ATOM_XML, (List)new .colon.colon((Object)MediaType.XML, (List)new .colon.colon((Object)MediaType.JSON, (List)Nil$.MODULE$)));
        this.supportedMetadataMediaTypes = new .colon.colon((Object)MediaType.XML, (List)Nil$.MODULE$);
    }
}

