/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.parser.util;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.annotations.EdmParameter;
import com.sdl.odata.api.edm.model.PrimitiveType;
import com.sdl.odata.api.parser.util.ParserUtil;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import com.sdl.odata.util.PrimitiveUtil;
import com.sdl.odata.util.ReferenceUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ParameterTypeUtil {
    private static final PrimitiveTypeNameResolver PRIMITIVE_TYPE_NAME_RESOLVER = new PrimitiveTypeNameResolver();

    private ParameterTypeUtil() {
    }

    public static void setParameter(Object object, Field field, Object bodyParameter) throws ODataUnmarshallingException {
        Object fieldValue = null;
        if (bodyParameter != null) {
            EdmParameter annotation = field.getAnnotation(EdmParameter.class);
            if (annotation == null) {
                throw new ODataUnmarshallingException("Field should have EdmParameter annotation");
            }
            PrimitiveType type = ParameterTypeUtil.resolveType(annotation.type(), field);
            try {
                if (field.getType().isAssignableFrom(bodyParameter.getClass())) {
                    fieldValue = bodyParameter;
                } else if (type != null) {
                    fieldValue = ParserUtil.parsePrimitiveValue(bodyParameter.toString(), type);
                }
            }
            catch (ODataException e) {
                throw new ODataUnmarshallingException("Can't parse primitive value");
            }
        }
        field.setAccessible(true);
        try {
            field.set(object, fieldValue);
        }
        catch (IllegalAccessException e) {
            throw new ODataUnmarshallingException("Error during setting a parameter to action object field");
        }
    }

    private static PrimitiveType resolveType(String type, Field field) {
        if (ReferenceUtil.isNullOrEmpty(type)) {
            return PRIMITIVE_TYPE_NAME_RESOLVER.resolveTypeName(field.getType());
        }
        return PrimitiveType.forName(type);
    }

    private static class PrimitiveTypeNameResolver {
        private Map<Class<?>, PrimitiveType> javaToPrimitiveType;

        PrimitiveTypeNameResolver() {
            HashMap javaToPrimitiveTypeBuilder = new HashMap();
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                Class<?> javaType = primitiveType.getJavaType();
                if (javaType == null) continue;
                javaToPrimitiveTypeBuilder.put(javaType, primitiveType);
            }
            this.javaToPrimitiveType = Collections.unmodifiableMap(javaToPrimitiveTypeBuilder);
        }

        public PrimitiveType resolveTypeName(Class<?> javaType) {
            return this.javaToPrimitiveType.get(PrimitiveUtil.unwrap(javaType));
        }
    }
}

