/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.util.edm;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.edm.ODataEdmException;
import com.sdl.odata.api.edm.model.Action;
import com.sdl.odata.api.edm.model.ActionImport;
import com.sdl.odata.api.edm.model.ComplexType;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntitySet;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.Function;
import com.sdl.odata.api.edm.model.FunctionImport;
import com.sdl.odata.api.edm.model.Key;
import com.sdl.odata.api.edm.model.MetaType;
import com.sdl.odata.api.edm.model.PrimitiveType;
import com.sdl.odata.api.edm.model.PropertyRef;
import com.sdl.odata.api.edm.model.Schema;
import com.sdl.odata.api.edm.model.Singleton;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.util.ReferenceUtil;
import com.sdl.odata.util.edm.PropertyVisitor;
import java.lang.reflect.Field;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityDataModelUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EntityDataModelUtil.class);

    private EntityDataModelUtil() {
    }

    public static Type getAndCheckType(EntityDataModel entityDataModel, String typeName) {
        Type type = entityDataModel.getType(typeName);
        if (type == null) {
            throw new ODataSystemException("Type not found in the entity data model: " + typeName);
        }
        return type;
    }

    public static Type getAndCheckType(EntityDataModel entityDataModel, Class<?> javaType) {
        Type type = entityDataModel.getType(javaType);
        if (type == null) {
            throw new ODataSystemException("No type found in the entity data model for Java type: " + javaType.getName());
        }
        return type;
    }

    public static boolean isPrimitiveType(Type type) {
        return type.getMetaType() == MetaType.PRIMITIVE;
    }

    public static PrimitiveType checkIsPrimitiveType(Type type) {
        if (!EntityDataModelUtil.isPrimitiveType(type)) {
            throw new ODataSystemException("A primitive type is required, but '" + type.getFullyQualifiedName() + "' is not a primitive type: " + (Object)((Object)type.getMetaType()));
        }
        return (PrimitiveType)type;
    }

    public static PrimitiveType getAndCheckPrimitiveType(EntityDataModel entityDataModel, String typeName) {
        return EntityDataModelUtil.checkIsPrimitiveType(EntityDataModelUtil.getAndCheckType(entityDataModel, typeName));
    }

    public static boolean isStructuredType(Type type) {
        MetaType metaType = type.getMetaType();
        return metaType == MetaType.ENTITY || metaType == MetaType.COMPLEX;
    }

    public static StructuredType checkIsStructuredType(Type type) {
        if (!EntityDataModelUtil.isStructuredType(type)) {
            throw new ODataSystemException("A structured type is required, but '" + type.getFullyQualifiedName() + "' is not a structured type: " + (Object)((Object)type.getMetaType()));
        }
        return (StructuredType)type;
    }

    public static StructuredType getAndCheckStructuredType(EntityDataModel entityDataModel, String typeName) {
        return EntityDataModelUtil.checkIsStructuredType(EntityDataModelUtil.getAndCheckType(entityDataModel, typeName));
    }

    public static StructuredType getAndCheckStructuredType(EntityDataModel entityDataModel, Class<?> javaType) {
        return EntityDataModelUtil.checkIsStructuredType(EntityDataModelUtil.getAndCheckType(entityDataModel, javaType));
    }

    public static boolean isEntityType(Type type) {
        return type.getMetaType() == MetaType.ENTITY;
    }

    public static EntityType checkIsEntityType(Type type) {
        if (!EntityDataModelUtil.isEntityType(type)) {
            throw new ODataSystemException("An entity type is required, but '" + type.getFullyQualifiedName() + "' is not an entity type: " + (Object)((Object)type.getMetaType()));
        }
        return (EntityType)type;
    }

    public static EntityType getAndCheckEntityType(EntityDataModel entityDataModel, String typeName) {
        return EntityDataModelUtil.checkIsEntityType(EntityDataModelUtil.getAndCheckType(entityDataModel, typeName));
    }

    public static EntityType getAndCheckEntityType(EntityDataModel entityDataModel, Class<?> javaType) {
        return EntityDataModelUtil.checkIsEntityType(EntityDataModelUtil.getAndCheckType(entityDataModel, javaType));
    }

    public static boolean isComplexType(Type type) {
        return type.getMetaType() == MetaType.COMPLEX;
    }

    public static ComplexType checkIsComplexType(Type type) {
        if (!EntityDataModelUtil.isComplexType(type)) {
            throw new ODataSystemException("A complex type is required, but '" + type.getFullyQualifiedName() + "' is not a complex type: " + (Object)((Object)type.getMetaType()));
        }
        return (ComplexType)type;
    }

    public static ComplexType getAndCheckComplexType(EntityDataModel entityDataModel, Class<?> javaType) {
        return EntityDataModelUtil.checkIsComplexType(EntityDataModelUtil.getAndCheckType(entityDataModel, javaType));
    }

    public static String getPropertyTypeName(StructuralProperty property) {
        return property.isCollection() ? property.getElementTypeName() : property.getTypeName();
    }

    public static Type getPropertyType(EntityDataModel entityDataModel, StructuralProperty property) {
        return EntityDataModelUtil.getAndCheckType(entityDataModel, EntityDataModelUtil.getPropertyTypeName(property));
    }

    public static Object getPropertyValue(StructuralProperty property, Object object) {
        Field field = property.getJavaField();
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new ODataSystemException("Cannot read property: " + property + " of object: " + object, e);
        }
    }

    public static void setPropertyValue(StructuralProperty property, Object object, Object value) {
        Field field = property.getJavaField();
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new ODataSystemException("Cannot write property: " + property + " of object: " + object, e);
        }
    }

    public static Collection<Object> createPropertyCollection(StructuralProperty property) {
        Class<?> fieldType = property.getJavaField().getType();
        if (List.class.isAssignableFrom(fieldType)) {
            return new ArrayList<Object>();
        }
        if (Set.class.isAssignableFrom(fieldType)) {
            return new HashSet<Object>();
        }
        throw new ODataSystemException("Unsupported collection type '" + fieldType.getName() + "' for property: " + property);
    }

    public static <E extends ODataException> void visitProperties(EntityDataModel entityDataModel, StructuredType structType, PropertyVisitor<E> visitor) throws E {
        String baseTypeName = structType.getBaseTypeName();
        if (!ReferenceUtil.isNullOrEmpty(baseTypeName)) {
            EntityDataModelUtil.visitProperties(entityDataModel, (StructuredType)entityDataModel.getType(baseTypeName), visitor);
        }
        for (StructuralProperty property : structType.getStructuralProperties()) {
            visitor.visit(property);
        }
    }

    public static StructuralProperty getStructuralProperty(EntityDataModel entityDataModel, StructuredType structuredType, String propertyName) {
        Type baseType;
        StructuralProperty structuralProperty = structuredType.getStructuralProperty(propertyName);
        if (structuralProperty != null) {
            return structuralProperty;
        }
        String baseTypeName = structuredType.getBaseTypeName();
        if (!ReferenceUtil.isNullOrEmpty(baseTypeName) && (baseType = entityDataModel.getType(baseTypeName)) != null && baseType instanceof StructuredType) {
            return EntityDataModelUtil.getStructuralProperty(entityDataModel, (StructuredType)baseType, propertyName);
        }
        return null;
    }

    public static Set<String> getKeyPropertyNames(EntityType entityType) {
        Set<String> keyPropertyNames = entityType.getKey().getPropertyRefs().stream().map(PropertyRef::getPath).collect(Collectors.toSet());
        return keyPropertyNames;
    }

    public static Map<String, Object> getKeyPropertyValues(EntityType entityType, Object entity) {
        HashMap<String, Object> keyPropertyValues = new HashMap<String, Object>();
        for (PropertyRef propertyRef : entityType.getKey().getPropertyRefs()) {
            String propertyName = propertyRef.getPath();
            Object propertyValue = EntityDataModelUtil.getPropertyValue(entityType.getStructuralProperty(propertyName), entity);
            keyPropertyValues.put(propertyName, propertyValue);
        }
        return keyPropertyValues;
    }

    public static EntitySet getAndCheckEntitySet(EntityDataModel entityDataModel, String entitySetName) {
        EntitySet entitySet = entityDataModel.getEntityContainer().getEntitySet(entitySetName);
        if (entitySet == null) {
            throw new ODataSystemException("Entity set not found in the entity data model: " + entitySetName);
        }
        return entitySet;
    }

    public static EntitySet getEntitySetByEntityTypeName(EntityDataModel entityDataModel, String entityTypeName) throws ODataEdmException {
        for (EntitySet entitySet : entityDataModel.getEntityContainer().getEntitySets()) {
            if (!entitySet.getTypeName().equals(entityTypeName)) continue;
            return entitySet;
        }
        throw new ODataSystemException("Entity set not found in the entity data model for type: " + entityTypeName);
    }

    public static String getEntityNameByEntityTypeName(EntityDataModel entityDataModel, String entityTypeName) throws ODataEdmException {
        for (EntitySet entitySet : entityDataModel.getEntityContainer().getEntitySets()) {
            if (!entitySet.getTypeName().equals(entityTypeName)) continue;
            return entitySet.getName();
        }
        for (Singleton singleton : entityDataModel.getEntityContainer().getSingletons()) {
            if (!singleton.getTypeName().equals(entityTypeName)) continue;
            return singleton.getName();
        }
        throw new ODataSystemException("Entity name not found in the entity data model for type: " + entityTypeName);
    }

    public static EntitySet getEntitySetByEntity(EntityDataModel entityDataModel, Object entity) throws ODataEdmException {
        return EntityDataModelUtil.getEntitySetByEntityTypeName(entityDataModel, EntityDataModelUtil.getAndCheckEntityType(entityDataModel, entity.getClass()).getFullyQualifiedName());
    }

    public static boolean isSingletonEntity(EntityDataModel entityDataModel, Object entity) throws ODataEdmException {
        EntityType entityType = EntityDataModelUtil.getAndCheckEntityType(entityDataModel, entity.getClass());
        boolean isSingletonEntity = false;
        for (Singleton singleton : entityDataModel.getEntityContainer().getSingletons()) {
            if (!singleton.getTypeName().equals(entityType.getFullyQualifiedName())) continue;
            isSingletonEntity = true;
            break;
        }
        return isSingletonEntity;
    }

    public static String getEntityName(EntityDataModel entityDataModel, Object entity) throws ODataEdmException {
        EntityType entityType = EntityDataModelUtil.getAndCheckEntityType(entityDataModel, entity.getClass());
        String entityName = null;
        for (EntitySet entitySet : entityDataModel.getEntityContainer().getEntitySets()) {
            if (!entitySet.getTypeName().equals(entityType.getFullyQualifiedName())) continue;
            entityName = entitySet.getName();
            break;
        }
        if (entityName == null) {
            for (Singleton singleton : entityDataModel.getEntityContainer().getSingletons()) {
                if (!singleton.getTypeName().equals(entityType.getFullyQualifiedName())) continue;
                entityName = singleton.getName();
                break;
            }
            if (entityName == null) {
                throw new ODataSystemException("Entity not found in the entity data model for type: " + entityType.getFullyQualifiedName());
            }
        }
        return entityName;
    }

    public static Singleton getAndCheckSingleton(EntityDataModel entityDataModel, String singletonName) {
        Singleton singleton = entityDataModel.getEntityContainer().getSingleton(singletonName);
        if (singleton == null) {
            throw new ODataSystemException("Singleton not found in the entity data model: " + singletonName);
        }
        return singleton;
    }

    public static FunctionImport getAndCheckFunctionImport(EntityDataModel entityDataModel, String functionImportName) {
        FunctionImport functionImport = entityDataModel.getEntityContainer().getFunctionImport(functionImportName);
        if (functionImport == null) {
            throw new ODataSystemException("Function import not found in the entity data model: " + functionImportName);
        }
        return functionImport;
    }

    public static Function getAndCheckFunction(EntityDataModel entityDataModel, String functionName) {
        int namespaceLastIndex = functionName.lastIndexOf(46);
        String namespace = functionName.substring(0, namespaceLastIndex);
        String simpleFunctionName = functionName.substring(namespaceLastIndex + 1);
        Schema schema = entityDataModel.getSchema(namespace);
        if (schema == null) {
            throw new ODataSystemException("Could not find schema in entity data model with namespace: " + namespace);
        }
        Function function = schema.getFunction(simpleFunctionName);
        if (function == null) {
            throw new ODataSystemException("Function not found in entity data model: " + functionName);
        }
        return function;
    }

    public static ActionImport getAndCheckActionImport(EntityDataModel entityDataModel, String actionImportName) {
        ActionImport actionImport = entityDataModel.getEntityContainer().getActionImport(actionImportName);
        if (actionImport == null) {
            throw new ODataSystemException("Action import not found in the entity data model: " + actionImportName);
        }
        return actionImport;
    }

    public static Action getAndCheckAction(EntityDataModel entityDataModel, String actionName) {
        int namespaceLastIndex = actionName.lastIndexOf(46);
        String namespace = actionName.substring(0, namespaceLastIndex);
        String simpleActionName = actionName.substring(namespaceLastIndex + 1);
        Schema schema = entityDataModel.getSchema(namespace);
        if (schema == null) {
            throw new ODataSystemException("Could not find schema in entity data model with namespace: " + namespace);
        }
        Action action = schema.getAction(simpleActionName);
        if (action == null) {
            throw new ODataSystemException("Action not found in entity data model: " + actionName);
        }
        return action;
    }

    public static boolean isCollection(EntityDataModel entityDataModel, String typeName) {
        EntitySet entitySet = entityDataModel.getEntityContainer().getEntitySet(typeName);
        if (entitySet != null) {
            return true;
        }
        try {
            if (Collection.class.isAssignableFrom(Class.forName(typeName))) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Not possible to find class for type name: " + typeName);
        }
        return false;
    }

    public static String formatEntityKey(EntityDataModel entityDataModel, Object entity) throws ODataEdmException {
        Key entityKey = EntityDataModelUtil.getAndCheckEntityType(entityDataModel, entity.getClass()).getKey();
        List<PropertyRef> keyPropertyRefs = entityKey.getPropertyRefs();
        try {
            if (keyPropertyRefs.size() == 1) {
                return EntityDataModelUtil.getKeyValueFromPropertyRef(entityDataModel, entity, keyPropertyRefs.get(0));
            }
            if (keyPropertyRefs.size() > 1) {
                ArrayList<String> processedKeys = new ArrayList<String>();
                for (PropertyRef propertyRef : keyPropertyRefs) {
                    processedKeys.add(String.format("%s=%s", propertyRef.getPath(), EntityDataModelUtil.getKeyValueFromPropertyRef(entityDataModel, entity, propertyRef)));
                }
                return processedKeys.stream().map(Object::toString).collect(Collectors.joining(","));
            }
            LOG.error("Not possible to retrieve entity key for entity " + entity);
            throw new ODataEdmException("Entity key is not found for " + entity);
        }
        catch (IllegalAccessException e) {
            LOG.error("Not possible to retrieve entity key for entity " + entity);
            throw new ODataEdmException("Not possible to retrieve entity key for entity " + entity, e);
        }
    }

    private static String getKeyValueFromPropertyRef(EntityDataModel entityDataModel, Object entity, PropertyRef propertyRef) throws IllegalAccessException, ODataEdmException {
        EntityType entityType = EntityDataModelUtil.getAndCheckEntityType(entityDataModel, entity.getClass());
        Field field = entityType.getStructuralProperty(propertyRef.getPath()).getJavaField();
        field.setAccessible(true);
        Object value = field.get(entity);
        if (value instanceof String) {
            return String.format("'%s'", ((String)value).replaceAll("'", "''"));
        }
        if (value instanceof Period) {
            return String.format("duration'%s'", value.toString());
        }
        return value != null ? value.toString() : null;
    }

    public static String pluralize(String word) {
        if (word == null) {
            throw new IllegalArgumentException();
        }
        String lowerCaseWord = word.toLowerCase();
        if (EntityDataModelUtil.endsWithAny(lowerCaseWord, "s", "sh", "o")) {
            return word + "es";
        }
        if (lowerCaseWord.endsWith("y") && !lowerCaseWord.endsWith("ay") || EntityDataModelUtil.endsWithAny(lowerCaseWord, "ey", "oy", "uy")) {
            return word.substring(0, word.length() - 1) + "ies";
        }
        return word + "s";
    }

    private static boolean endsWithAny(String word, String ... endings) {
        for (String ending : endings) {
            if (!word.endsWith(ending)) continue;
            return true;
        }
        return false;
    }
}

