/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.service;

import com.sdl.odata.api.ODataUnsupportedMediaTypeException;
import com.sdl.odata.api.parser.BatchUri$;
import com.sdl.odata.api.parser.EntityUri;
import com.sdl.odata.api.parser.FormatOption;
import com.sdl.odata.api.parser.MetadataUri;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil$;
import com.sdl.odata.api.parser.RelativeUri;
import com.sdl.odata.api.parser.ResourcePathUri;
import com.sdl.odata.api.parser.ServiceRootUri;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;

public final class ODataRequestContextUtil$ {
    public static final ODataRequestContextUtil$ MODULE$;
    private final List<MediaType> com$sdl$odata$api$service$ODataRequestContextUtil$$supportedMediaTypes;
    private final List<MediaType> com$sdl$odata$api$service$ODataRequestContextUtil$$supportedMetadataMediaTypes;

    static {
        new ODataRequestContextUtil$();
    }

    public List<MediaType> com$sdl$odata$api$service$ODataRequestContextUtil$$supportedMediaTypes() {
        return this.com$sdl$odata$api$service$ODataRequestContextUtil$$supportedMediaTypes;
    }

    public List<MediaType> com$sdl$odata$api$service$ODataRequestContextUtil$$supportedMetadataMediaTypes() {
        return this.com$sdl$odata$api$service$ODataRequestContextUtil$$supportedMetadataMediaTypes;
    }

    public void checkSupportedType(ODataRequestContext requestContext) {
        if (this.isMediaTypeSpecified(requestContext) && !this.isMediaTypesSupported(requestContext)) {
            throw new ODataUnsupportedMediaTypeException("Unsupported media type");
        }
    }

    public boolean isMediaTypeSpecified(ODataRequestContext requestContext) {
        return requestContext.getRequest().getAccept().size() > 0 || ODataUriUtil$.MODULE$.getFormatOption(requestContext.getUri()).isDefined();
    }

    public boolean isMediaTypesSupported(ODataRequestContext context) {
        block7: {
            boolean bl;
            block3: {
                ODataUri oDataUri;
                block6: {
                    RelativeUri relativeUri;
                    block5: {
                        RelativeUri relativeUri2;
                        block4: {
                            RelativeUri relativeUri3;
                            block2: {
                                RelativeUri relativeUri4;
                                oDataUri = context.getUri();
                                if (oDataUri == null || !((relativeUri4 = oDataUri.relativeUri()) instanceof MetadataUri)) break block2;
                                bl = this.isMetadataMediaTypesSupported(context.getRequest()) || this.isMetadataMediaTypesSupported(context.getUri());
                                break block3;
                            }
                            if (oDataUri == null || !((relativeUri3 = oDataUri.relativeUri()) instanceof ServiceRootUri)) break block4;
                            bl = this.isMediaTypesSupported(context.getRequest()) || this.isMediaTypesSupported(context.getUri());
                            break block3;
                        }
                        if (oDataUri == null || !((relativeUri2 = oDataUri.relativeUri()) instanceof EntityUri)) break block5;
                        bl = this.isMediaTypesSupported(context.getRequest()) || this.isMediaTypesSupported(context.getUri());
                        break block3;
                    }
                    if (oDataUri == null || !((relativeUri = oDataUri.relativeUri()) instanceof ResourcePathUri)) break block6;
                    bl = this.isMediaTypesSupported(context.getRequest()) || this.isMediaTypesSupported(context.getUri());
                    break block3;
                }
                if (oDataUri == null) break block7;
                RelativeUri relativeUri = oDataUri.relativeUri();
                BatchUri$ batchUri$ = BatchUri$.MODULE$;
                RelativeUri relativeUri5 = relativeUri;
                if (batchUri$ != null ? !batchUri$.equals(relativeUri5) : relativeUri5 != null) break block7;
                bl = this.isMediaTypesSupported(context.getRequest()) || this.isMediaTypesSupported(context.getUri());
            }
            return bl;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No implementation for ", ".getUri"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context})));
    }

    public boolean isMediaTypesSupported(ODataRequest request) {
        return JavaConversions$.MODULE$.asScalaBuffer(request.getAccept()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MediaType mediaType) {
                return ODataRequestContextUtil$.MODULE$.com$sdl$odata$api$service$ODataRequestContextUtil$$supportedMediaTypes().exists((Function1)new Serializable(this, mediaType){
                    public static final long serialVersionUID = 0L;
                    private final MediaType mediaType$1;

                    public final boolean apply(MediaType x$1) {
                        return x$1.matches(this.mediaType$1);
                    }
                    {
                        this.mediaType$1 = mediaType$1;
                    }
                });
            }
        });
    }

    public boolean isMediaTypesSupported(ODataUri oDataUri) {
        boolean bl;
        Option<FormatOption> option = ODataUriUtil$.MODULE$.getFormatOption(oDataUri);
        if (option instanceof Some) {
            Some some = (Some)option;
            FormatOption formatOpt = (FormatOption)some.x();
            bl = this.com$sdl$odata$api$service$ODataRequestContextUtil$$supportedMediaTypes().contains((Object)formatOpt.mediaType());
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isMetadataMediaTypesSupported(ODataRequest request) {
        return JavaConversions$.MODULE$.asScalaBuffer(request.getAccept()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MediaType mediaType) {
                return ODataRequestContextUtil$.MODULE$.com$sdl$odata$api$service$ODataRequestContextUtil$$supportedMetadataMediaTypes().exists((Function1)new Serializable(this, mediaType){
                    public static final long serialVersionUID = 0L;
                    private final MediaType mediaType$2;

                    public final boolean apply(MediaType x$2) {
                        return x$2.matches(this.mediaType$2);
                    }
                    {
                        this.mediaType$2 = mediaType$2;
                    }
                });
            }
        });
    }

    public boolean isMetadataMediaTypesSupported(ODataUri oDataUri) {
        boolean bl;
        Option<FormatOption> option = ODataUriUtil$.MODULE$.getFormatOption(oDataUri);
        if (option instanceof Some) {
            Some some = (Some)option;
            FormatOption formatOpt = (FormatOption)some.x();
            bl = this.com$sdl$odata$api$service$ODataRequestContextUtil$$supportedMetadataMediaTypes().contains((Object)formatOpt.mediaType());
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isReadOperation(ODataRequestContext context) {
        ODataRequest.Method method = context.getRequest().getMethod();
        ODataRequest.Method method2 = ODataRequest.Method.GET;
        ODataRequest.Method method3 = method;
        boolean bl = !(method2 != null ? !((Object)((Object)method2)).equals((Object)method3) : method3 != null);
        return bl;
    }

    public boolean isWriteOperation(ODataRequestContext context) {
        boolean bl;
        ODataRequest.Method method = context.getRequest().getMethod();
        ODataRequest.Method method2 = ODataRequest.Method.POST;
        ODataRequest.Method method3 = method;
        if (!(method2 != null ? !((Object)((Object)method2)).equals((Object)method3) : method3 != null)) {
            bl = true;
        } else {
            ODataRequest.Method method4 = ODataRequest.Method.PATCH;
            ODataRequest.Method method5 = method;
            if (!(method4 != null ? !((Object)((Object)method4)).equals((Object)method5) : method5 != null)) {
                bl = true;
            } else {
                ODataRequest.Method method6 = ODataRequest.Method.PUT;
                ODataRequest.Method method7 = method;
                if (!(method6 != null ? !((Object)((Object)method6)).equals((Object)method7) : method7 != null)) {
                    bl = true;
                } else {
                    ODataRequest.Method method8 = ODataRequest.Method.DELETE;
                    ODataRequest.Method method9 = method;
                    bl = !(method8 != null ? !((Object)((Object)method8)).equals((Object)method9) : method9 != null);
                }
            }
        }
        return bl;
    }

    public boolean isBatchOperation(ODataRequestContext context) {
        RelativeUri relativeUri = context.getUri().relativeUri();
        BatchUri$ batchUri$ = BatchUri$.MODULE$;
        RelativeUri relativeUri2 = relativeUri;
        boolean bl = !(batchUri$ != null ? !batchUri$.equals(relativeUri2) : relativeUri2 != null) && relativeUri instanceof BatchUri$;
        return bl;
    }

    private ODataRequestContextUtil$() {
        MODULE$ = this;
        this.com$sdl$odata$api$service$ODataRequestContextUtil$$supportedMediaTypes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MediaType[]{MediaType.ATOM_XML, MediaType.XML, MediaType.JSON}));
        this.com$sdl$odata$api$service$ODataRequestContextUtil$$supportedMetadataMediaTypes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MediaType[]{MediaType.XML}));
    }
}

