/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.service;

import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestResponseBase;
import com.sdl.odata.util.ReferenceUtil;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ODataRequest
extends ODataRequestResponseBase {
    private final Method method;
    private final String uri;

    private ODataRequest(Builder builder) {
        super(Collections.unmodifiableMap(builder.headersBuilder), builder.body);
        if (builder.method == null) {
            throw new IllegalArgumentException("Method is required");
        }
        if (ReferenceUtil.isNullOrEmpty(builder.uri)) {
            throw new IllegalArgumentException("URI is required");
        }
        this.method = builder.method;
        this.uri = builder.uri;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public List<String> getPrefer() {
        String preferHeader = this.getHeader("Prefer");
        if (ReferenceUtil.isNullOrEmpty(preferHeader)) {
            return Collections.emptyList();
        }
        List preferList = Arrays.stream(preferHeader.split(",")).map(String::trim).collect(Collectors.toList());
        return Collections.unmodifiableList(preferList);
    }

    public String toString() {
        return (Object)((Object)this.method) + " " + this.uri;
    }

    public static class Builder {
        private Method method;
        private String uri;
        private final Map<String, String> headersBuilder = new HashMap<String, String>();
        private byte[] body;

        public Builder setMethod(Method builderMethod) {
            this.method = builderMethod;
            return this;
        }

        public Builder setUri(String builderUri) {
            this.uri = builderUri;
            return this;
        }

        public Builder setHeader(String name, String value) {
            this.headersBuilder.put(name, value);
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headersBuilder.putAll(headers);
            return this;
        }

        public Builder setAccept(MediaType ... mediaTypes) {
            this.headersBuilder.put("Accept", Arrays.stream(mediaTypes).map(Object::toString).collect(Collectors.joining(", ")));
            return this;
        }

        public Builder setContentType(MediaType mediaType) {
            this.headersBuilder.put("Content-Type", mediaType.toString());
            return this;
        }

        public Builder setPrefer(String ... prefers) {
            this.headersBuilder.put("Prefer", Stream.of(prefers).collect(Collectors.joining(",")));
            return this;
        }

        public Builder setBody(byte[] builderBody) {
            this.body = builderBody;
            return this;
        }

        public Builder setBodyText(String bodyText, String charset) throws UnsupportedEncodingException {
            this.body = bodyText.getBytes(charset);
            return this;
        }

        public ODataRequest build() {
            return new ODataRequest(this);
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        PATCH;

    }
}

