/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MediaType {
    public static final MediaType XML = new MediaType("application", "xml");
    public static final MediaType ATOM_XML = new MediaType("application", "atom+xml");
    public static final MediaType MULTIPART = new MediaType("multipart", "mixed");
    public static final MediaType HTTP = new MediaType("multipart", "application/http");
    public static final MediaType ATOM_SVC_XML = new MediaType("application", "atomsvc+xml");
    public static final MediaType JSON = new MediaType("application", "json");
    public static final MediaType WILDCARD_ANY = new MediaType("*", "*");
    public static final int HASH = 31;
    public static final int GROUP_INDEX = 4;
    public static final int TYPE_INDEX = 2;
    public static final int SUBTYPE_INDEX = 3;
    public static final int GROUP_MATCHER_INDEX = 5;
    private static final Pattern MEDIA_TYPE_PATTERN = Pattern.compile("(([^/]+)/([^/;]+)|(\\*))(.*)");
    private static final Pattern PARAMETER_PATTERN = Pattern.compile(";\\s*([^;=]+)=([^;=]+)");
    private final String type;
    private final String subType;
    private final Map<String, String> parameters;

    public MediaType(String type, String subType, Map<String, String> parameters) {
        this.type = type;
        this.subType = subType;
        this.parameters = parameters != null ? Collections.unmodifiableMap(parameters) : Collections.emptyMap();
    }

    public MediaType(String type, String subType) {
        this(type, subType, null);
    }

    public static MediaType fromString(String text) {
        String subType;
        String type;
        Matcher matcher = MEDIA_TYPE_PATTERN.matcher(text);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid media type string: " + text);
        }
        if (matcher.group(4) != null) {
            type = matcher.group(4);
            subType = matcher.group(4);
        } else {
            type = matcher.group(2);
            subType = matcher.group(3);
        }
        HashMap<String, String> parametersBuilder = new HashMap<String, String>();
        Matcher parametersMatcher = PARAMETER_PATTERN.matcher(matcher.group(5));
        while (parametersMatcher.find()) {
            parametersBuilder.put(parametersMatcher.group(1), parametersMatcher.group(2));
        }
        return new MediaType(type, subType, Collections.unmodifiableMap(parametersBuilder));
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public boolean matches(MediaType that) {
        return !(!this.type.equals("*") && !that.type.equals("*") && !this.type.equalsIgnoreCase(that.type) || !this.subType.equals("*") && !that.subType.equals("*") && !this.subType.equalsIgnoreCase(that.subType));
    }

    public boolean isWildCardMediaType() {
        return WILDCARD_ANY.getType().equals(this.type) && WILDCARD_ANY.getSubType().equals(this.subType);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        MediaType mediaType = (MediaType)that;
        if (this.parameters != null ? !this.parameters.equals(mediaType.parameters) : mediaType.parameters != null) {
            return false;
        }
        if (!this.subType.equals(mediaType.subType)) {
            return false;
        }
        return this.type.equals(mediaType.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subType.hashCode();
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type).append('/').append(this.subType);
        for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
            sb.append(';').append(parameter.getKey()).append('=').append(parameter.getValue());
        }
        return sb.toString();
    }
}

