/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.processor;

import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import java.util.HashMap;
import java.util.Map;

public final class ProcessorResult {
    private final ODataResponse.Status status;
    private final Object data;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final ODataRequestContext requestContext;

    public ProcessorResult(ODataResponse.Status status) {
        this.status = status;
        this.data = null;
        this.requestContext = null;
    }

    public ProcessorResult(ODataResponse.Status status, Map<String, String> headers) {
        this.status = status;
        this.data = null;
        this.headers.putAll(headers);
        this.requestContext = null;
    }

    public ProcessorResult(ODataResponse.Status status, Object data) {
        this.status = status;
        this.data = data;
        this.requestContext = null;
    }

    public ProcessorResult(ODataResponse.Status status, Object data, Map<String, String> headers) {
        this.status = status;
        this.data = data;
        this.headers.putAll(headers);
        this.requestContext = null;
    }

    public ProcessorResult(ODataResponse.Status status, Object data, Map<String, String> headers, ODataRequestContext requestContext) {
        this.status = status;
        this.data = data;
        this.headers.putAll(headers);
        this.requestContext = requestContext;
    }

    public ODataResponse.Status getStatus() {
        return this.status;
    }

    public Object getData() {
        return this.data;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ODataRequestContext getRequestContext() {
        return this.requestContext;
    }

    public String toString() {
        return "ProcessorResult { status=" + (Object)((Object)this.status) + ", data=" + this.data + ", headers=" + this.headers + " }";
    }
}

