/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.edm.model;

import com.sdl.odata.api.edm.model.MetaType;
import com.sdl.odata.api.edm.model.Type;

public enum AbstractType implements Type
{
    PRIMITIVE_TYPE("PrimitiveType"),
    COMPLEX_TYPE("ComplexType"),
    ENTITY_TYPE("EntityType");

    private final String name;

    private AbstractType(String name) {
        this.name = name;
    }

    public static AbstractType forName(String name) {
        String simpleName = name.startsWith("Edm") ? name.substring("Edm".length() + 1) : name;
        for (AbstractType abstractType : AbstractType.values()) {
            if (!abstractType.name.equals(simpleName)) continue;
            return abstractType;
        }
        throw new IllegalArgumentException("Invalid abstract type name: " + name);
    }

    @Override
    public MetaType getMetaType() {
        return MetaType.ABSTRACT;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return "Edm";
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getNamespace() + "." + this.getName();
    }

    @Override
    public Class<?> getJavaType() {
        return null;
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }
}

