/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.dxa.modules.smarttarget.mapping;

import com.sdl.dxa.api.datamodel.model.ContentModelData;
import com.sdl.dxa.api.datamodel.model.PageModelData;
import com.sdl.dxa.api.datamodel.model.RegionModelData;
import com.sdl.dxa.modules.smarttarget.mapping.AbstractSmartTargetPageBuilder;
import com.sdl.dxa.modules.smarttarget.model.entity.SmartTargetPageModel;
import com.sdl.dxa.modules.smarttarget.model.entity.SmartTargetRegion;
import com.sdl.dxa.tridion.mapping.PageModelBuilder;
import com.sdl.webapp.common.api.WebRequestContext;
import com.sdl.webapp.common.api.localization.Localization;
import com.sdl.webapp.common.api.model.PageModel;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SmartTargetPageBuilder
extends AbstractSmartTargetPageBuilder
implements PageModelBuilder {
    private static final Logger log = LoggerFactory.getLogger(SmartTargetPageBuilder.class);
    private final WebRequestContext webRequestContext;

    @Autowired
    public SmartTargetPageBuilder(HttpServletRequest httpServletRequest, WebRequestContext webRequestContext) {
        super(httpServletRequest);
        this.webRequestContext = webRequestContext;
    }

    public PageModel buildPageModel(@Nullable PageModel pageModel, @NotNull PageModelData modelData) {
        if (pageModel == null || pageModel.getRegions() == null || !pageModel.getRegions().containsClass(SmartTargetRegion.class) || modelData.getRegions() == null) {
            log.debug("There are no SmartTargetRegions on the page {}", (Object)pageModel);
            return pageModel;
        }
        Localization localization = this.webRequestContext.getLocalization();
        String allowDuplicationOnSamePage = modelData.getMetadata() == null ? null : String.valueOf(modelData.getMetadata().get((Object)"allowDuplicationOnSamePage"));
        SmartTargetPageModel stPageModel = new SmartTargetPageModel(pageModel).setAllowDuplicates(SmartTargetPageBuilder.getAllowDuplicatesFromConfig((String)allowDuplicationOnSamePage, (Localization)localization));
        pageModel.getRegions().stream().filter(regionModel -> regionModel instanceof SmartTargetRegion).map(regionModel -> (SmartTargetRegion)regionModel).forEach(regionModel -> {
            RegionModelData regionModelData = modelData.getRegions().stream().filter(rmd -> rmd.getName().equals(regionModel.getName())).findFirst().orElse(null);
            ContentModelData metadata = regionModelData == null ? null : regionModelData.getMetadata();
            String maxItems = metadata == null ? null : (String)metadata.getAndCast((Object)"maxItems", String.class);
            SmartTargetPageBuilder.setMaxItems((String)maxItems, (SmartTargetRegion)regionModel);
        });
        String promotionViewName = SmartTargetPageBuilder.getPromotionViewName((Localization)localization);
        log.debug("Using promotion view name {}", (Object)promotionViewName);
        this.processQueryAndPromotions(localization, stPageModel, promotionViewName);
        return stPageModel;
    }
}

