/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.ccm;

import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.testinfra.CassandraResourceRule;
import com.datastax.oss.driver.api.testinfra.ScyllaOnly;
import com.datastax.oss.driver.api.testinfra.ScyllaSkip;
import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;
import com.datastax.oss.driver.api.testinfra.requirement.BackendRequirementRule;
import com.datastax.oss.driver.api.testinfra.requirement.BackendType;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class BaseCcmRule
extends CassandraResourceRule {
    protected final CcmBridge ccmBridge;

    BaseCcmRule(CcmBridge ccmBridge) {
        this.ccmBridge = ccmBridge;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                ccmBridge.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    protected void before() {
        this.ccmBridge.create();
        this.ccmBridge.start();
    }

    protected void after() {
        this.ccmBridge.close();
    }

    public Statement apply(Statement base, final Description description) {
        ScyllaSkip scyllaSkip = (ScyllaSkip)description.getAnnotation(ScyllaSkip.class);
        if (scyllaSkip != null && CcmBridge.isDistributionOf(BackendType.SCYLLA)) {
            return new Statement(){

                public void evaluate() {
                    throw new AssumptionViolatedException(String.format("Test skipped when running with Scylla.  Description: %s", description));
                }
            };
        }
        ScyllaOnly scyllaOnly = (ScyllaOnly)description.getAnnotation(ScyllaOnly.class);
        if (scyllaOnly != null && !CcmBridge.isDistributionOf(BackendType.SCYLLA)) {
            return new Statement(){

                public void evaluate() {
                    throw new AssumptionViolatedException(String.format("Test skipped when running against non-scylla backend.  Description: %s", description));
                }
            };
        }
        if (BackendRequirementRule.meetsDescriptionRequirements(description)) {
            return super.apply(base, description);
        }
        return new Statement(){

            public void evaluate() {
                throw new AssumptionViolatedException(BackendRequirementRule.buildReasonString(description));
            }
        };
    }

    public BackendType getDistribution() {
        return CcmBridge.DISTRIBUTION;
    }

    public boolean isDistributionOf(BackendType type) {
        return CcmBridge.isDistributionOf(type);
    }

    public boolean isDistributionOf(BackendType type, CcmBridge.VersionComparator comparator) {
        return CcmBridge.isDistributionOf(type, comparator);
    }

    public Version getDistributionVersion() {
        return CcmBridge.getDistributionVersion();
    }

    public Version getCassandraVersion() {
        return CcmBridge.getCassandraVersion();
    }

    @Override
    public ProtocolVersion getHighestProtocolVersion() {
        if (CcmBridge.getCassandraVersion().compareTo(Version.V2_2_0) >= 0) {
            return DefaultProtocolVersion.V4;
        }
        return DefaultProtocolVersion.V3;
    }

    @Override
    public Set<EndPoint> getContactPoints() {
        return Collections.singleton(new DefaultEndPoint(new InetSocketAddress(this.ccmBridge.getNodeIpAddress(1), 9042)));
    }

    public Set<EndPoint> getContactPointsWithShardAwarePort() {
        if (!CcmBridge.isDistributionOf(BackendType.SCYLLA)) {
            throw new UnsupportedOperationException("Shard aware port is only supported in Scylla");
        }
        return Collections.singleton(new DefaultEndPoint(new InetSocketAddress(this.ccmBridge.getNodeIpAddress(1), 19042)));
    }
}

