/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.ccm;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;
import com.datastax.oss.driver.api.testinfra.requirement.BackendType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSortedMap;
import java.util.HashMap;
import java.util.Map;

public abstract class DistributionCassandraVersions {
    private static final Map<BackendType, ImmutableSortedMap<Version, Version>> mappings = new HashMap<BackendType, ImmutableSortedMap<Version, Version>>();

    public static Version getCassandraVersion(BackendType type, Version version) {
        ImmutableSortedMap<Version, Version> mapping = mappings.get((Object)type);
        if (mapping == null) {
            return null;
        }
        return (Version)mapping.floorEntry((Object)version).getValue();
    }

    static {
        ImmutableSortedMap dse = ImmutableSortedMap.of((Comparable)Version.V1_0_0, (Object)CcmBridge.V2_1_19, (Comparable)Version.V5_0_0, (Object)CcmBridge.V3_0_15, (Comparable)CcmBridge.V5_1_0, (Object)CcmBridge.V3_10, (Comparable)CcmBridge.V6_0_0, (Object)CcmBridge.V4_0_0);
        mappings.put(BackendType.DSE, (ImmutableSortedMap<Version, Version>)dse);
        ImmutableSortedMap hcd = ImmutableSortedMap.of((Comparable)Version.V1_0_0, (Object)CcmBridge.V4_0_11);
        mappings.put(BackendType.HCD, (ImmutableSortedMap<Version, Version>)hcd);
        ImmutableSortedMap scylla = ImmutableSortedMap.of((Comparable)Version.V1_0_0, (Object)CcmBridge.V3_0_15);
        mappings.put(BackendType.SCYLLA, (ImmutableSortedMap<Version, Version>)scylla);
    }
}

