/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.ccm;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;

public class DefaultCcmBridgeBuilderCustomizer {
    public static CcmBridge.Builder configureBuilder(CcmBridge.Builder builder) {
        if (!CcmBridge.DSE_ENABLEMENT.booleanValue() && CcmBridge.VERSION.nextStable().compareTo(Version.V4_0_0) >= 0) {
            if (CcmBridge.VERSION.nextStable().compareTo(Version.V4_1_0) >= 0) {
                builder.withCassandraConfiguration("materialized_views_enabled", true);
                builder.withCassandraConfiguration("sasi_indexes_enabled", true);
            } else {
                builder.withCassandraConfiguration("enable_materialized_views", true);
                builder.withCassandraConfiguration("enable_sasi_indexes", true);
            }
        }
        if (CcmBridge.VERSION.nextStable().compareTo(Version.V3_0_0) >= 0) {
            if (!CcmBridge.SCYLLA_ENABLEMENT.booleanValue()) {
                builder.withJvmArgs("-Dcassandra.superuser_setup_delay_ms=0");
                builder.withJvmArgs("-Dcassandra.skip_wait_for_gossip_to_settle=0");
            }
            builder.withCassandraConfiguration("num_tokens", "1");
            builder.withCassandraConfiguration("initial_token", "0");
        }
        return builder;
    }
}

