/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.ccm;

import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.testinfra.CassandraRequirement;
import com.datastax.oss.driver.api.testinfra.CassandraResourceRule;
import com.datastax.oss.driver.api.testinfra.DseRequirement;
import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;
import java.util.Optional;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class BaseCcmRule
extends CassandraResourceRule {
    protected final CcmBridge ccmBridge;

    BaseCcmRule(CcmBridge ccmBridge) {
        this.ccmBridge = ccmBridge;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                ccmBridge.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    protected void before() {
        this.ccmBridge.create();
        this.ccmBridge.start();
    }

    protected void after() {
        this.ccmBridge.remove();
    }

    private Statement buildErrorStatement(final Version requirement, final String description, final boolean lessThan, final boolean dse) {
        return new Statement(){

            public void evaluate() {
                throw new AssumptionViolatedException(String.format("Test requires %s %s %s but %s is configured.  Description: %s", lessThan ? "less than" : "at least", dse ? "DSE" : "C*", requirement, dse ? BaseCcmRule.this.ccmBridge.getDseVersion().orElse(null) : BaseCcmRule.this.ccmBridge.getCassandraVersion(), description));
            }
        };
    }

    public Statement apply(Statement base, Description description) {
        DseRequirement dseRequirement;
        CassandraRequirement cassandraRequirement = (CassandraRequirement)description.getAnnotation(CassandraRequirement.class);
        if (cassandraRequirement != null) {
            Version maxVersion;
            Version minVersion;
            if (!cassandraRequirement.min().isEmpty() && (minVersion = Version.parse((String)cassandraRequirement.min())).compareTo(this.ccmBridge.getCassandraVersion()) > 0) {
                return this.buildErrorStatement(minVersion, cassandraRequirement.description(), false, false);
            }
            if (!cassandraRequirement.max().isEmpty() && (maxVersion = Version.parse((String)cassandraRequirement.max())).compareTo(this.ccmBridge.getCassandraVersion()) <= 0) {
                return this.buildErrorStatement(maxVersion, cassandraRequirement.description(), true, false);
            }
        }
        if ((dseRequirement = (DseRequirement)description.getAnnotation(DseRequirement.class)) != null) {
            Version maxVersion;
            Version minVersion;
            Optional<Version> dseVersionOption = this.ccmBridge.getDseVersion();
            if (!dseVersionOption.isPresent()) {
                return new Statement(){

                    public void evaluate() {
                        throw new AssumptionViolatedException("Test Requires DSE but C* is configured.");
                    }
                };
            }
            Version dseVersion = dseVersionOption.get();
            if (!dseRequirement.min().isEmpty() && (minVersion = Version.parse((String)dseRequirement.min())).compareTo(dseVersion) > 0) {
                return this.buildErrorStatement(minVersion, dseRequirement.description(), false, true);
            }
            if (!dseRequirement.max().isEmpty() && (maxVersion = Version.parse((String)dseRequirement.max())).compareTo(dseVersion) <= 0) {
                return this.buildErrorStatement(maxVersion, dseRequirement.description(), true, true);
            }
        }
        return super.apply(base, description);
    }

    public Version getCassandraVersion() {
        return this.ccmBridge.getCassandraVersion();
    }

    public Optional<Version> getDseVersion() {
        return this.ccmBridge.getDseVersion();
    }

    @Override
    public ProtocolVersion getHighestProtocolVersion() {
        if (this.ccmBridge.getCassandraVersion().compareTo(Version.V2_2_0) >= 0) {
            return DefaultProtocolVersion.V4;
        }
        return DefaultProtocolVersion.V3;
    }
}

