/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.CodecNotFoundException;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.querybuilder.BindMarker;
import com.datastax.oss.driver.api.querybuilder.Literal;
import com.datastax.oss.driver.api.querybuilder.Raw;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.api.querybuilder.insert.InsertInto;
import com.datastax.oss.driver.api.querybuilder.select.SelectFrom;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.truncate.Truncate;
import com.datastax.oss.driver.api.querybuilder.update.UpdateStart;
import com.datastax.oss.driver.internal.core.metadata.schema.ShallowUserDefinedType;
import com.datastax.oss.driver.internal.querybuilder.ArithmeticOperator;
import com.datastax.oss.driver.internal.querybuilder.DefaultLiteral;
import com.datastax.oss.driver.internal.querybuilder.DefaultRaw;
import com.datastax.oss.driver.internal.querybuilder.delete.DefaultDelete;
import com.datastax.oss.driver.internal.querybuilder.insert.DefaultInsert;
import com.datastax.oss.driver.internal.querybuilder.select.DefaultBindMarker;
import com.datastax.oss.driver.internal.querybuilder.select.DefaultSelect;
import com.datastax.oss.driver.internal.querybuilder.term.BinaryArithmeticTerm;
import com.datastax.oss.driver.internal.querybuilder.term.FunctionTerm;
import com.datastax.oss.driver.internal.querybuilder.term.OppositeTerm;
import com.datastax.oss.driver.internal.querybuilder.term.TupleTerm;
import com.datastax.oss.driver.internal.querybuilder.term.TypeHintTerm;
import com.datastax.oss.driver.internal.querybuilder.truncate.DefaultTruncate;
import com.datastax.oss.driver.internal.querybuilder.update.DefaultUpdate;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;

public class QueryBuilder {
    @NonNull
    public static SelectFrom selectFrom(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table) {
        return new DefaultSelect(keyspace, table);
    }

    @NonNull
    public static SelectFrom selectFrom(@Nullable String keyspace, @NonNull String table) {
        return QueryBuilder.selectFrom(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)table));
    }

    @NonNull
    public static SelectFrom selectFrom(@NonNull CqlIdentifier table) {
        return QueryBuilder.selectFrom(null, table);
    }

    @NonNull
    public static SelectFrom selectFrom(@NonNull String table) {
        return QueryBuilder.selectFrom(CqlIdentifier.fromCql((String)table));
    }

    @NonNull
    public static InsertInto insertInto(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table) {
        return new DefaultInsert(keyspace, table);
    }

    @NonNull
    public static InsertInto insertInto(@Nullable String keyspace, @NonNull String table) {
        return QueryBuilder.insertInto(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)table));
    }

    @NonNull
    public static InsertInto insertInto(@NonNull CqlIdentifier table) {
        return QueryBuilder.insertInto(null, table);
    }

    @NonNull
    public static InsertInto insertInto(@NonNull String table) {
        return QueryBuilder.insertInto(CqlIdentifier.fromCql((String)table));
    }

    @NonNull
    public static UpdateStart update(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table) {
        return new DefaultUpdate(keyspace, table);
    }

    @NonNull
    public static UpdateStart update(@Nullable String keyspace, @NonNull String table) {
        return QueryBuilder.update(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)table));
    }

    @NonNull
    public static UpdateStart update(@NonNull CqlIdentifier table) {
        return QueryBuilder.update(null, table);
    }

    @NonNull
    public static UpdateStart update(@NonNull String table) {
        return QueryBuilder.update(CqlIdentifier.fromCql((String)table));
    }

    @NonNull
    public static DeleteSelection deleteFrom(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table) {
        return new DefaultDelete(keyspace, table);
    }

    @NonNull
    public static DeleteSelection deleteFrom(@Nullable String keyspace, @NonNull String table) {
        return QueryBuilder.deleteFrom(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)table));
    }

    @NonNull
    public static DeleteSelection deleteFrom(@NonNull CqlIdentifier table) {
        return QueryBuilder.deleteFrom(null, table);
    }

    @NonNull
    public static DeleteSelection deleteFrom(@NonNull String table) {
        return QueryBuilder.deleteFrom(CqlIdentifier.fromCql((String)table));
    }

    @NonNull
    public static Term tuple(@NonNull Iterable<? extends Term> components) {
        return new TupleTerm(components);
    }

    @NonNull
    public static Term tuple(Term ... components) {
        return QueryBuilder.tuple(Arrays.asList(components));
    }

    @NonNull
    public static Term add(@NonNull Term left, @NonNull Term right) {
        return new BinaryArithmeticTerm(ArithmeticOperator.SUM, left, right);
    }

    @NonNull
    public static Term subtract(@NonNull Term left, @NonNull Term right) {
        return new BinaryArithmeticTerm(ArithmeticOperator.DIFFERENCE, left, right);
    }

    @NonNull
    public static Term multiply(@NonNull Term left, @NonNull Term right) {
        return new BinaryArithmeticTerm(ArithmeticOperator.PRODUCT, left, right);
    }

    @NonNull
    public static Term divide(@NonNull Term left, @NonNull Term right) {
        return new BinaryArithmeticTerm(ArithmeticOperator.QUOTIENT, left, right);
    }

    @NonNull
    public static Term remainder(@NonNull Term left, @NonNull Term right) {
        return new BinaryArithmeticTerm(ArithmeticOperator.REMAINDER, left, right);
    }

    @NonNull
    public static Term negate(@NonNull Term argument) {
        return new OppositeTerm(argument);
    }

    @NonNull
    public static Term function(@NonNull CqlIdentifier functionId, @NonNull Iterable<Term> arguments) {
        return QueryBuilder.function(null, functionId, arguments);
    }

    @NonNull
    public static Term function(@NonNull CqlIdentifier functionId, Term ... arguments) {
        return QueryBuilder.function(functionId, Arrays.asList(arguments));
    }

    @NonNull
    public static Term function(@NonNull String functionName, @NonNull Iterable<Term> arguments) {
        return QueryBuilder.function(CqlIdentifier.fromCql((String)functionName), arguments);
    }

    @NonNull
    public static Term function(@NonNull String functionName, Term ... arguments) {
        return QueryBuilder.function(CqlIdentifier.fromCql((String)functionName), arguments);
    }

    @NonNull
    public static Term function(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier functionId, @NonNull Iterable<Term> arguments) {
        return new FunctionTerm(keyspaceId, functionId, arguments);
    }

    @NonNull
    public static Term function(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier functionId, Term ... arguments) {
        return QueryBuilder.function(keyspaceId, functionId, Arrays.asList(arguments));
    }

    @NonNull
    public static Term function(@Nullable String keyspaceName, @NonNull String functionName, @NonNull Iterable<Term> arguments) {
        return QueryBuilder.function(keyspaceName == null ? null : CqlIdentifier.fromCql((String)keyspaceName), CqlIdentifier.fromCql((String)functionName), arguments);
    }

    @NonNull
    public static Term function(@Nullable String keyspaceName, @NonNull String functionName, Term ... arguments) {
        return QueryBuilder.function(keyspaceName == null ? null : CqlIdentifier.fromCql((String)keyspaceName), CqlIdentifier.fromCql((String)functionName), arguments);
    }

    @NonNull
    public static Term typeHint(@NonNull Term term, @NonNull DataType targetType) {
        return new TypeHintTerm(term, targetType);
    }

    @NonNull
    public static Term now() {
        return QueryBuilder.function("now", new Term[0]);
    }

    @NonNull
    public static Term currentTimestamp() {
        return QueryBuilder.function("currenttimestamp", new Term[0]);
    }

    @NonNull
    public static Term currentDate() {
        return QueryBuilder.function("currentdate", new Term[0]);
    }

    @NonNull
    public static Term currentTime() {
        return QueryBuilder.function("currenttime", new Term[0]);
    }

    @NonNull
    public static Term currentTimeUuid() {
        return QueryBuilder.function("currenttimeuuid", new Term[0]);
    }

    @NonNull
    public static Term minTimeUuid(@NonNull Term argument) {
        return QueryBuilder.function("mintimeuuid", argument);
    }

    @NonNull
    public static Term maxTimeUuid(@NonNull Term argument) {
        return QueryBuilder.function("maxtimeuuid", argument);
    }

    @NonNull
    public static Term toDate(@NonNull Term argument) {
        return QueryBuilder.function("todate", argument);
    }

    @NonNull
    public static Term toTimestamp(@NonNull Term argument) {
        return QueryBuilder.function("totimestamp", argument);
    }

    @NonNull
    public static Term toUnixTimestamp(@NonNull Term argument) {
        return QueryBuilder.function("tounixtimestamp", argument);
    }

    @NonNull
    public static Literal literal(@Nullable Object value) {
        return QueryBuilder.literal(value, CodecRegistry.DEFAULT);
    }

    @NonNull
    public static Literal literal(@Nullable Object value, @NonNull CodecRegistry codecRegistry) {
        try {
            return QueryBuilder.literal(value, value == null ? null : codecRegistry.codecFor(value));
        }
        catch (CodecNotFoundException e) {
            assert (value != null);
            throw new IllegalArgumentException(String.format("Could not inline literal of type %s. This happens because the driver doesn't know how to map it to a CQL type. Try passing a TypeCodec or CodecRegistry to literal().", value.getClass().getName()), e);
        }
    }

    @NonNull
    public static <T> Literal literal(@Nullable T value, @Nullable TypeCodec<T> codec) {
        return new DefaultLiteral<T>(value, codec);
    }

    @NonNull
    public static Raw raw(@NonNull String raw) {
        return new DefaultRaw(raw);
    }

    @NonNull
    public static BindMarker bindMarker() {
        return QueryBuilder.bindMarker((CqlIdentifier)null);
    }

    @NonNull
    public static BindMarker bindMarker(@Nullable CqlIdentifier id) {
        return new DefaultBindMarker(id);
    }

    @NonNull
    public static BindMarker bindMarker(@Nullable String name) {
        return QueryBuilder.bindMarker(name == null ? null : CqlIdentifier.fromCql((String)name));
    }

    @NonNull
    public static UserDefinedType udt(@NonNull CqlIdentifier name) {
        return new ShallowUserDefinedType(null, name, false);
    }

    @NonNull
    public static UserDefinedType udt(@NonNull String name) {
        return QueryBuilder.udt(CqlIdentifier.fromCql((String)name));
    }

    public static Truncate truncate(@NonNull CqlIdentifier table) {
        return QueryBuilder.truncate(null, table);
    }

    public static Truncate truncate(@NonNull String table) {
        return QueryBuilder.truncate(null, CqlIdentifier.fromCql((String)table));
    }

    public static Truncate truncate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table) {
        return new DefaultTruncate(keyspace, table);
    }

    public static Truncate truncate(@Nullable String keyspace, @NonNull String table) {
        return QueryBuilder.truncate(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)table));
    }
}

