/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.MapperException;
import com.datastax.oss.driver.api.mapper.entity.naming.NameConverter;
import com.datastax.oss.driver.api.mapper.result.MapperResultProducer;
import com.datastax.oss.driver.api.mapper.result.MapperResultProducerService;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultMapperContext
implements MapperContext {
    private static final List<MapperResultProducer> RESULT_PRODUCERS = DefaultMapperContext.getResultProducers();
    private static final ConcurrentMap<GenericType<?>, MapperResultProducer> RESULT_PRODUCER_CACHE = new ConcurrentHashMap();
    private final CqlSession session;
    private final CqlIdentifier keyspaceId;
    private final CqlIdentifier tableId;
    private final String executionProfileName;
    private final DriverExecutionProfile executionProfile;
    private final ConcurrentMap<Class<? extends NameConverter>, NameConverter> nameConverterCache;
    private final Map<Object, Object> customState;

    public DefaultMapperContext(@NonNull CqlSession session, @Nullable CqlIdentifier keyspaceId, @Nullable String executionProfileName, @Nullable DriverExecutionProfile executionProfile, @NonNull Map<Object, Object> customState) {
        this(session, keyspaceId, null, executionProfileName, executionProfile, new ConcurrentHashMap<Class<? extends NameConverter>, NameConverter>(), (Map<Object, Object>)NullAllowingImmutableMap.copyOf(customState));
    }

    private DefaultMapperContext(CqlSession session, CqlIdentifier keyspaceId, CqlIdentifier tableId, String executionProfileName, DriverExecutionProfile executionProfile, ConcurrentMap<Class<? extends NameConverter>, NameConverter> nameConverterCache, Map<Object, Object> customState) {
        if (executionProfile != null && executionProfileName != null) {
            throw new IllegalArgumentException("Can't provide both a profile and a name");
        }
        this.session = session;
        this.keyspaceId = keyspaceId;
        this.tableId = tableId;
        this.nameConverterCache = nameConverterCache;
        this.customState = customState;
        this.executionProfileName = executionProfileName;
        this.executionProfile = executionProfile;
    }

    public DefaultMapperContext withDaoParameters(@Nullable CqlIdentifier newKeyspaceId, @Nullable CqlIdentifier newTableId, @Nullable String newExecutionProfileName, @Nullable DriverExecutionProfile newExecutionProfile) {
        return Objects.equals(newKeyspaceId, this.keyspaceId) && Objects.equals(newTableId, this.tableId) && Objects.equals(newExecutionProfileName, this.executionProfileName) && Objects.equals(newExecutionProfile, this.executionProfile) ? this : new DefaultMapperContext(this.session, newKeyspaceId, newTableId, newExecutionProfileName, newExecutionProfile, this.nameConverterCache, this.customState);
    }

    @Override
    @NonNull
    public CqlSession getSession() {
        return this.session;
    }

    @Override
    @Nullable
    public CqlIdentifier getKeyspaceId() {
        return this.keyspaceId;
    }

    @Override
    @Nullable
    public CqlIdentifier getTableId() {
        return this.tableId;
    }

    @Override
    @Nullable
    public String getExecutionProfileName() {
        return this.executionProfileName;
    }

    @Override
    @Nullable
    public DriverExecutionProfile getExecutionProfile() {
        return this.executionProfile;
    }

    @Override
    @NonNull
    public NameConverter getNameConverter(Class<? extends NameConverter> converterClass) {
        return this.nameConverterCache.computeIfAbsent(converterClass, DefaultMapperContext::buildNameConverter);
    }

    @Override
    @NonNull
    public Map<Object, Object> getCustomState() {
        return this.customState;
    }

    @Override
    @NonNull
    public MapperResultProducer getResultProducer(@NonNull GenericType<?> resultToProduce) {
        return RESULT_PRODUCER_CACHE.computeIfAbsent(resultToProduce, k -> {
            for (MapperResultProducer resultProducer : RESULT_PRODUCERS) {
                if (!resultProducer.canProduce((GenericType<?>)k)) continue;
                return resultProducer;
            }
            throw new IllegalArgumentException(String.format("Found no registered %s that can produce %s", MapperResultProducer.class.getSimpleName(), k));
        });
    }

    private static NameConverter buildNameConverter(Class<? extends NameConverter> converterClass) {
        try {
            return converterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MapperException(String.format("Error while building an instance of %s. %s implementations must have a public no-arg constructor", converterClass, NameConverter.class.getSimpleName()), e);
        }
    }

    private static List<MapperResultProducer> getResultProducers() {
        ImmutableList.Builder result = ImmutableList.builder();
        ServiceLoader<MapperResultProducerService> loader = ServiceLoader.load(MapperResultProducerService.class);
        loader.iterator().forEachRemaining(provider -> result.addAll(provider.getProducers()));
        return result.build();
    }
}

