/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.mapper.entity.naming.NamingConvention;
import com.datastax.oss.driver.internal.mapper.processor.entity.BuiltInNameConversions;
import com.squareup.javapoet.CodeBlock;
import javax.lang.model.type.TypeMirror;

public class CqlNameGenerator {
    public static final CqlNameGenerator DEFAULT = new CqlNameGenerator(NamingConvention.SNAKE_CASE_INSENSITIVE);
    private final NamingConvention namingConvention;
    private final TypeMirror converterClassMirror;

    public CqlNameGenerator(NamingConvention namingConvention) {
        this(namingConvention, null);
    }

    public CqlNameGenerator(TypeMirror converterClassMirror) {
        this(null, converterClassMirror);
    }

    private CqlNameGenerator(NamingConvention namingConvention, TypeMirror converterClassMirror) {
        assert (namingConvention == null ^ converterClassMirror == null);
        this.namingConvention = namingConvention;
        this.converterClassMirror = converterClassMirror;
    }

    public CodeBlock buildCqlName(String javaName) {
        if (this.namingConvention != null) {
            return CodeBlock.of((String)"$S", (Object[])new Object[]{BuiltInNameConversions.toCassandraName(javaName, this.namingConvention)});
        }
        return CodeBlock.of((String)"context.getNameConverter($T.class).toCassandraName($S)", (Object[])new Object[]{this.converterClassMirror, javaName});
    }
}

