/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.RequestThrottlingException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.connection.FrameTooLongException;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.token.Partitioner;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.FunctionFailureException;
import com.datastax.oss.driver.api.core.servererrors.ProtocolError;
import com.datastax.oss.driver.api.core.servererrors.QueryValidationException;
import com.datastax.oss.driver.api.core.servererrors.ReadTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.UnavailableException;
import com.datastax.oss.driver.api.core.servererrors.WriteTimeoutException;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.api.core.session.throttling.Throttled;
import com.datastax.oss.driver.api.core.specex.SpeculativeExecutionPolicy;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.internal.core.adminrequest.ThrottledAdminRequestHandler;
import com.datastax.oss.driver.internal.core.adminrequest.UnexpectedResponseException;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.driver.internal.core.cql.DefaultExecutionInfo;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.token.DefaultTokenMap;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.RepreparePayload;
import com.datastax.oss.driver.internal.core.tracker.NoopRequestTracker;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.internal.core.util.collection.QueryPlan;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Prepare;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.error.Unprepared;
import com.datastax.oss.protocol.internal.response.result.Rows;
import com.datastax.oss.protocol.internal.response.result.SchemaChange;
import com.datastax.oss.protocol.internal.response.result.SetKeyspace;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.handler.codec.EncoderException;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CqlRequestHandler
implements Throttled {
    private static final Logger LOG = LoggerFactory.getLogger(CqlRequestHandler.class);
    private static final long NANOTIME_NOT_MEASURED_YET = -1L;
    private final long startTimeNanos = System.nanoTime();
    private final String logPrefix;
    private final Statement<?> statement;
    private final DefaultSession session;
    private final CqlIdentifier keyspace;
    private final InternalDriverContext context;
    @NonNull
    private final DriverExecutionProfile executionProfile;
    private final boolean isIdempotent;
    protected final CompletableFuture<AsyncResultSet> result;
    private final Message message;
    private final Timer timer;
    private final AtomicInteger activeExecutionsCount;
    private final AtomicInteger startedSpeculativeExecutionsCount;
    private final Duration timeout;
    final Timeout scheduledTimeout;
    final List<Timeout> scheduledExecutions;
    private final List<NodeResponseCallback> inFlightCallbacks;
    private final RetryPolicy retryPolicy;
    private final SpeculativeExecutionPolicy speculativeExecutionPolicy;
    private final RequestThrottler throttler;
    private final RequestTracker requestTracker;
    private final SessionMetricUpdater sessionMetricUpdater;
    private volatile List<Map.Entry<Node, Throwable>> errors;

    protected CqlRequestHandler(Statement<?> statement, DefaultSession session, InternalDriverContext context, String sessionLogPrefix) {
        this.logPrefix = sessionLogPrefix + "|" + this.hashCode();
        LOG.trace("[{}] Creating new handler for request {}", (Object)this.logPrefix, statement);
        this.statement = statement;
        this.session = session;
        this.keyspace = session.getKeyspace().orElse(null);
        this.context = context;
        this.executionProfile = Conversions.resolveExecutionProfile(statement, context);
        this.retryPolicy = context.getRetryPolicy(this.executionProfile.getName());
        this.speculativeExecutionPolicy = context.getSpeculativeExecutionPolicy(this.executionProfile.getName());
        Boolean statementIsIdempotent = statement.isIdempotent();
        this.isIdempotent = statementIsIdempotent == null ? this.executionProfile.getBoolean(DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE) : statementIsIdempotent.booleanValue();
        this.result = new CompletableFuture();
        this.result.exceptionally(t -> {
            try {
                if (t instanceof CancellationException) {
                    this.cancelScheduledTasks();
                }
            }
            catch (Throwable t2) {
                Loggers.warnWithException(LOG, "[{}] Uncaught exception", this.logPrefix, t2);
            }
            return null;
        });
        this.message = Conversions.toMessage(statement, this.executionProfile, context);
        this.timer = context.getNettyOptions().getTimer();
        this.timeout = statement.getTimeout() != null ? statement.getTimeout() : this.executionProfile.getDuration(DefaultDriverOption.REQUEST_TIMEOUT);
        this.scheduledTimeout = this.scheduleTimeout(this.timeout);
        this.activeExecutionsCount = new AtomicInteger(1);
        this.startedSpeculativeExecutionsCount = new AtomicInteger(0);
        this.scheduledExecutions = this.isIdempotent ? new CopyOnWriteArrayList() : null;
        this.inFlightCallbacks = new CopyOnWriteArrayList<NodeResponseCallback>();
        this.requestTracker = context.getRequestTracker();
        this.sessionMetricUpdater = session.getMetricUpdater();
        this.throttler = context.getRequestThrottler();
        this.throttler.register(this);
    }

    @Override
    public void onThrottleReady(boolean wasDelayed) {
        if (wasDelayed && this.sessionMetricUpdater.isEnabled(DefaultSessionMetric.THROTTLING_DELAY, this.executionProfile.getName())) {
            this.sessionMetricUpdater.updateTimer(DefaultSessionMetric.THROTTLING_DELAY, this.executionProfile.getName(), System.nanoTime() - this.startTimeNanos, TimeUnit.NANOSECONDS);
        }
        Queue<Node> queryPlan = this.statement.getNode() != null ? new QueryPlan(this.statement.getNode()) : this.context.getLoadBalancingPolicyWrapper().newQueryPlan(this.statement, this.executionProfile.getName(), this.session);
        this.sendRequest(null, queryPlan, 0, 0, true);
    }

    public CompletionStage<AsyncResultSet> handle() {
        return this.result;
    }

    private Timeout scheduleTimeout(Duration timeoutDuration) {
        if (timeoutDuration.toNanos() > 0L) {
            try {
                return this.timer.newTimeout(timeout1 -> this.setFinalError(new DriverTimeoutException("Query timed out after " + timeoutDuration), null, -1), timeoutDuration.toNanos(), TimeUnit.NANOSECONDS);
            }
            catch (IllegalStateException e) {
                this.result.completeExceptionally("cannot be started once stopped".equals(e.getMessage()) ? new IllegalStateException("Session is closed") : e);
            }
        }
        return null;
    }

    private Token getRoutingToken() {
        Token token = this.statement.getRoutingToken();
        if (token != null) {
            return token;
        }
        ByteBuffer key = this.statement.getRoutingKey();
        if (key == null) {
            return null;
        }
        Partitioner partitioner = this.statement.getPartitioner();
        if (partitioner != null) {
            return partitioner.hash(key);
        }
        TokenMap tokenMap = this.context.getMetadataManager().getMetadata().getTokenMap().orElse(null);
        return tokenMap == null ? null : ((DefaultTokenMap)tokenMap).getTokenFactory().hash(key);
    }

    private void sendRequest(Node retriedNode, Queue<Node> queryPlan, int currentExecutionIndex, int retryCount, boolean scheduleNextExecution) {
        if (this.result.isDone()) {
            return;
        }
        Node node = retriedNode;
        DriverChannel channel = null;
        if (node == null || (channel = this.session.getChannel(node, this.logPrefix, this.getRoutingToken())) == null) {
            while (!this.result.isDone() && (node = queryPlan.poll()) != null && (channel = this.session.getChannel(node, this.logPrefix, this.getRoutingToken())) == null) {
            }
        }
        if (channel == null) {
            if (!this.result.isDone() && this.activeExecutionsCount.decrementAndGet() == 0) {
                this.setFinalError(AllNodesFailedException.fromErrors(this.errors), null, -1);
            }
        } else {
            NodeResponseCallback nodeResponseCallback = new NodeResponseCallback(node, queryPlan, channel, currentExecutionIndex, retryCount, scheduleNextExecution, this.logPrefix);
            channel.write(this.message, this.statement.isTracing(), this.statement.getCustomPayload(), nodeResponseCallback).addListener((GenericFutureListener)nodeResponseCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordError(Node node, Throwable error) {
        List<Map.Entry<Node, Throwable>> errorsSnapshot = this.errors;
        if (errorsSnapshot == null) {
            CqlRequestHandler cqlRequestHandler = this;
            synchronized (cqlRequestHandler) {
                errorsSnapshot = this.errors;
                if (errorsSnapshot == null) {
                    this.errors = errorsSnapshot = new CopyOnWriteArrayList<Map.Entry<Node, Throwable>>();
                }
            }
        }
        errorsSnapshot.add(new AbstractMap.SimpleEntry<Node, Throwable>(node, error));
    }

    private void cancelScheduledTasks() {
        if (this.scheduledTimeout != null) {
            this.scheduledTimeout.cancel();
        }
        if (this.scheduledExecutions != null) {
            for (Timeout scheduledExecution : this.scheduledExecutions) {
                scheduledExecution.cancel();
            }
        }
        for (NodeResponseCallback callback : this.inFlightCallbacks) {
            callback.cancel();
        }
    }

    private void setFinalResult(Result resultMessage, Frame responseFrame, boolean schemaInAgreement, NodeResponseCallback callback) {
        try {
            ExecutionInfo executionInfo = this.buildExecutionInfo(callback, resultMessage, responseFrame, schemaInAgreement);
            AsyncResultSet resultSet = Conversions.toResultSet(resultMessage, executionInfo, this.session, this.context);
            if (this.result.complete(resultSet)) {
                this.cancelScheduledTasks();
                this.throttler.signalSuccess(this);
                long completionTimeNanos = -1L;
                long totalLatencyNanos = -1L;
                if (!(this.requestTracker instanceof NoopRequestTracker)) {
                    completionTimeNanos = System.nanoTime();
                    totalLatencyNanos = completionTimeNanos - this.startTimeNanos;
                    long nodeLatencyNanos = completionTimeNanos - callback.nodeStartTimeNanos;
                    this.requestTracker.onNodeSuccess(this.statement, nodeLatencyNanos, this.executionProfile, callback.node, this.logPrefix);
                    this.requestTracker.onSuccess(this.statement, totalLatencyNanos, this.executionProfile, callback.node, this.logPrefix);
                }
                if (this.sessionMetricUpdater.isEnabled(DefaultSessionMetric.CQL_REQUESTS, this.executionProfile.getName())) {
                    if (completionTimeNanos == -1L) {
                        completionTimeNanos = System.nanoTime();
                        totalLatencyNanos = completionTimeNanos - this.startTimeNanos;
                    }
                    this.sessionMetricUpdater.updateTimer(DefaultSessionMetric.CQL_REQUESTS, this.executionProfile.getName(), totalLatencyNanos, TimeUnit.NANOSECONDS);
                }
            }
            if (!executionInfo.getWarnings().isEmpty() && this.executionProfile.getBoolean(DefaultDriverOption.REQUEST_LOG_WARNINGS) && LOG.isWarnEnabled()) {
                this.logServerWarnings(executionInfo.getWarnings());
            }
        }
        catch (Throwable error) {
            this.setFinalError(error, callback.node, -1);
        }
    }

    private void logServerWarnings(List<String> warnings) {
        StringBuilder statementString = new StringBuilder();
        this.context.getRequestLogFormatter().appendRequest(this.statement, this.executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_QUERY_LENGTH, 500), this.executionProfile.getBoolean(DefaultDriverOption.REQUEST_LOGGER_VALUES, true), this.executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_VALUES, 50), this.executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_VALUE_LENGTH, 50), statementString);
        warnings.forEach(warning -> LOG.warn("Query '{}' generated server side warning(s): {}", (Object)statementString, warning));
    }

    private ExecutionInfo buildExecutionInfo(NodeResponseCallback callback, Result resultMessage, Frame responseFrame, boolean schemaInAgreement) {
        ByteBuffer pagingState = resultMessage instanceof Rows ? ((Rows)resultMessage).getMetadata().pagingState : null;
        return new DefaultExecutionInfo(this.statement, callback.node, this.startedSpeculativeExecutionsCount.get(), callback.execution, this.errors, pagingState, responseFrame, schemaInAgreement, this.session, this.context, this.executionProfile);
    }

    @Override
    public void onThrottleFailure(@NonNull RequestThrottlingException error) {
        this.sessionMetricUpdater.incrementCounter(DefaultSessionMetric.THROTTLING_ERRORS, this.executionProfile.getName());
        this.setFinalError(error, null, -1);
    }

    private void setFinalError(Throwable error, Node node, int execution) {
        if (error instanceof DriverException) {
            ((DriverException)error).setExecutionInfo(new DefaultExecutionInfo(this.statement, node, this.startedSpeculativeExecutionsCount.get(), execution, this.errors, null, null, true, this.session, this.context, this.executionProfile));
        }
        if (this.result.completeExceptionally(error)) {
            this.cancelScheduledTasks();
            if (!(this.requestTracker instanceof NoopRequestTracker)) {
                long latencyNanos = System.nanoTime() - this.startTimeNanos;
                this.requestTracker.onError(this.statement, error, latencyNanos, this.executionProfile, node, this.logPrefix);
            }
            if (error instanceof DriverTimeoutException) {
                this.throttler.signalTimeout(this);
                this.sessionMetricUpdater.incrementCounter(DefaultSessionMetric.CQL_CLIENT_TIMEOUTS, this.executionProfile.getName());
            } else if (!(error instanceof RequestThrottlingException)) {
                this.throttler.signalError(this, error);
            }
        }
    }

    private class NodeResponseCallback
    implements ResponseCallback,
    GenericFutureListener<Future<Void>> {
        private final long nodeStartTimeNanos = System.nanoTime();
        private final Node node;
        private final Queue<Node> queryPlan;
        private final DriverChannel channel;
        private final int execution;
        private final int retryCount;
        private final boolean scheduleNextExecution;
        private final String logPrefix;

        private NodeResponseCallback(Node node, Queue<Node> queryPlan, DriverChannel channel, int execution, int retryCount, boolean scheduleNextExecution, String logPrefix) {
            this.node = node;
            this.queryPlan = queryPlan;
            this.channel = channel;
            this.execution = execution;
            this.retryCount = retryCount;
            this.scheduleNextExecution = scheduleNextExecution;
            this.logPrefix = logPrefix + "|" + execution;
        }

        public void operationComplete(Future<Void> future) throws Exception {
            if (!future.isSuccess()) {
                Throwable error = future.cause();
                if (error instanceof EncoderException && error.getCause() instanceof FrameTooLongException) {
                    this.trackNodeError(this.node, error.getCause(), -1L);
                    CqlRequestHandler.this.setFinalError(error.getCause(), this.node, this.execution);
                } else {
                    LOG.trace("[{}] Failed to send request on {}, trying next node (cause: {})", new Object[]{this.logPrefix, this.channel, error});
                    CqlRequestHandler.this.recordError(this.node, error);
                    this.trackNodeError(this.node, error, -1L);
                    ((DefaultNode)this.node).getMetricUpdater().incrementCounter(DefaultNodeMetric.UNSENT_REQUESTS, CqlRequestHandler.this.executionProfile.getName());
                    CqlRequestHandler.this.sendRequest(null, this.queryPlan, this.execution, this.retryCount, this.scheduleNextExecution);
                }
            } else {
                LOG.trace("[{}] Request sent on {}", (Object)this.logPrefix, (Object)this.channel);
                if (CqlRequestHandler.this.result.isDone()) {
                    this.cancel();
                } else {
                    CqlRequestHandler.this.inFlightCallbacks.add(this);
                    if (this.scheduleNextExecution && CqlRequestHandler.this.isIdempotent) {
                        long nextDelay;
                        int nextExecution = this.execution + 1;
                        try {
                            nextDelay = CqlRequestHandler.this.speculativeExecutionPolicy.nextExecution(this.node, CqlRequestHandler.this.keyspace, CqlRequestHandler.this.statement, nextExecution);
                        }
                        catch (Throwable cause) {
                            LOG.error("[{}] Unexpected error while invoking the speculative execution policy", (Object)this.logPrefix, (Object)cause);
                            return;
                        }
                        if (nextDelay >= 0L) {
                            this.scheduleSpeculativeExecution(nextExecution, nextDelay);
                        } else {
                            LOG.trace("[{}] Speculative execution policy returned {}, no next execution", (Object)this.logPrefix, (Object)nextDelay);
                        }
                    }
                }
            }
        }

        private void scheduleSpeculativeExecution(int index, long delay) {
            block2: {
                LOG.trace("[{}] Scheduling speculative execution {} in {} ms", new Object[]{this.logPrefix, index, delay});
                try {
                    CqlRequestHandler.this.scheduledExecutions.add(CqlRequestHandler.this.timer.newTimeout(timeout1 -> {
                        if (!CqlRequestHandler.this.result.isDone()) {
                            LOG.trace("[{}] Starting speculative execution {}", (Object)CqlRequestHandler.this.logPrefix, (Object)index);
                            CqlRequestHandler.this.activeExecutionsCount.incrementAndGet();
                            CqlRequestHandler.this.startedSpeculativeExecutionsCount.incrementAndGet();
                            ((DefaultNode)this.node).getMetricUpdater().incrementCounter(DefaultNodeMetric.SPECULATIVE_EXECUTIONS, CqlRequestHandler.this.executionProfile.getName());
                            CqlRequestHandler.this.sendRequest(null, this.queryPlan, index, 0, true);
                        }
                    }, delay, TimeUnit.MILLISECONDS));
                }
                catch (IllegalStateException e) {
                    if ("cannot be started once stopped".equals(e.getMessage())) break block2;
                    Loggers.warnWithException(LOG, "[{}] Error while scheduling speculative execution", this.logPrefix, e);
                }
            }
        }

        @Override
        public void onResponse(Frame responseFrame) {
            long nodeResponseTimeNanos = -1L;
            NodeMetricUpdater nodeMetricUpdater = ((DefaultNode)this.node).getMetricUpdater();
            if (nodeMetricUpdater.isEnabled(DefaultNodeMetric.CQL_MESSAGES, CqlRequestHandler.this.executionProfile.getName())) {
                nodeResponseTimeNanos = System.nanoTime();
                long nodeLatency = System.nanoTime() - this.nodeStartTimeNanos;
                nodeMetricUpdater.updateTimer(DefaultNodeMetric.CQL_MESSAGES, CqlRequestHandler.this.executionProfile.getName(), nodeLatency, TimeUnit.NANOSECONDS);
            }
            CqlRequestHandler.this.inFlightCallbacks.remove(this);
            if (CqlRequestHandler.this.result.isDone()) {
                return;
            }
            try {
                Message responseMessage = responseFrame.message;
                if (responseMessage instanceof SchemaChange) {
                    SchemaChange schemaChange = (SchemaChange)responseMessage;
                    CqlRequestHandler.this.context.getMetadataManager().refreshSchema(schemaChange.keyspace, false, false).whenComplete((result, error) -> {
                        boolean schemaInAgreement;
                        if (error != null) {
                            Loggers.warnWithException(LOG, "[{}] Unexpected error while refreshing schema after DDL query, keeping previous version", this.logPrefix, error);
                            schemaInAgreement = false;
                        } else {
                            schemaInAgreement = result.isSchemaInAgreement();
                        }
                        CqlRequestHandler.this.setFinalResult((Result)schemaChange, responseFrame, schemaInAgreement, this);
                    });
                } else if (responseMessage instanceof SetKeyspace) {
                    SetKeyspace setKeyspace = (SetKeyspace)responseMessage;
                    CqlRequestHandler.this.session.setKeyspace(CqlIdentifier.fromInternal(setKeyspace.keyspace)).whenComplete((v, error) -> CqlRequestHandler.this.setFinalResult((Result)setKeyspace, responseFrame, true, this));
                } else if (responseMessage instanceof Result) {
                    LOG.trace("[{}] Got result, completing", (Object)this.logPrefix);
                    CqlRequestHandler.this.setFinalResult((Result)responseMessage, responseFrame, true, this);
                } else if (responseMessage instanceof Error) {
                    LOG.trace("[{}] Got error response, processing", (Object)this.logPrefix);
                    this.processErrorResponse((Error)responseMessage);
                } else {
                    this.trackNodeError(this.node, new IllegalStateException("Unexpected response " + responseMessage), nodeResponseTimeNanos);
                    CqlRequestHandler.this.setFinalError(new IllegalStateException("Unexpected response " + responseMessage), this.node, this.execution);
                }
            }
            catch (Throwable t) {
                this.trackNodeError(this.node, t, nodeResponseTimeNanos);
                CqlRequestHandler.this.setFinalError(t, this.node, this.execution);
            }
        }

        private void processErrorResponse(Error errorMessage) {
            if (errorMessage.code == 9472) {
                ByteBuffer idToReprepare = ByteBuffer.wrap(((Unprepared)errorMessage).id);
                LOG.trace("[{}] Statement {} is not prepared on {}, repreparing", new Object[]{this.logPrefix, Bytes.toHexString((ByteBuffer)idToReprepare), this.node});
                RepreparePayload repreparePayload = (RepreparePayload)CqlRequestHandler.this.session.getRepreparePayloads().get(idToReprepare);
                if (repreparePayload == null) {
                    throw new IllegalStateException(String.format("Tried to execute unprepared query %s but we don't have the data to reprepare it", Bytes.toHexString((ByteBuffer)idToReprepare)));
                }
                Prepare reprepareMessage = repreparePayload.toMessage();
                ThrottledAdminRequestHandler<ByteBuffer> reprepareHandler = ThrottledAdminRequestHandler.prepare(this.channel, true, (Message)reprepareMessage, repreparePayload.customPayload, CqlRequestHandler.this.timeout, CqlRequestHandler.this.throttler, CqlRequestHandler.this.sessionMetricUpdater, this.logPrefix);
                reprepareHandler.start().handle((repreparedId, exception) -> {
                    if (exception != null) {
                        if (exception instanceof UnexpectedResponseException) {
                            CoordinatorException prepareError;
                            Message prepareErrorMessage = ((UnexpectedResponseException)exception).message;
                            if (prepareErrorMessage instanceof Error && ((prepareError = Conversions.toThrowable(this.node, (Error)prepareErrorMessage, CqlRequestHandler.this.context)) instanceof QueryValidationException || prepareError instanceof FunctionFailureException || prepareError instanceof ProtocolError)) {
                                LOG.trace("[{}] Unrecoverable error on reprepare, rethrowing", (Object)this.logPrefix);
                                this.trackNodeError(this.node, prepareError, -1L);
                                CqlRequestHandler.this.setFinalError(prepareError, this.node, this.execution);
                                return null;
                            }
                        } else if (exception instanceof RequestThrottlingException) {
                            this.trackNodeError(this.node, (Throwable)exception, -1L);
                            CqlRequestHandler.this.setFinalError(exception, this.node, this.execution);
                            return null;
                        }
                        CqlRequestHandler.this.recordError(this.node, exception);
                        this.trackNodeError(this.node, (Throwable)exception, -1L);
                        LOG.trace("[{}] Reprepare failed, trying next node", (Object)this.logPrefix);
                        CqlRequestHandler.this.sendRequest(null, this.queryPlan, this.execution, this.retryCount, false);
                    } else {
                        if (!repreparedId.equals(idToReprepare)) {
                            IllegalStateException illegalStateException = new IllegalStateException(String.format("ID mismatch while trying to reprepare (expected %s, got %s). This prepared statement won't work anymore. This usually happens when you run a 'USE...' query after the statement was prepared.", Bytes.toHexString((ByteBuffer)idToReprepare), Bytes.toHexString((ByteBuffer)repreparedId)));
                            this.trackNodeError(this.node, illegalStateException, -1L);
                            CqlRequestHandler.this.setFinalError(illegalStateException, this.node, this.execution);
                        }
                        LOG.trace("[{}] Reprepare sucessful, retrying", (Object)this.logPrefix);
                        CqlRequestHandler.this.sendRequest(this.node, this.queryPlan, this.execution, this.retryCount, false);
                    }
                    return null;
                });
                return;
            }
            CoordinatorException error = Conversions.toThrowable(this.node, errorMessage, CqlRequestHandler.this.context);
            NodeMetricUpdater metricUpdater = ((DefaultNode)this.node).getMetricUpdater();
            if (error instanceof BootstrappingException) {
                LOG.trace("[{}] {} is bootstrapping, trying next node", (Object)this.logPrefix, (Object)this.node);
                CqlRequestHandler.this.recordError(this.node, error);
                this.trackNodeError(this.node, error, -1L);
                CqlRequestHandler.this.sendRequest(null, this.queryPlan, this.execution, this.retryCount, false);
            } else if (error instanceof QueryValidationException || error instanceof FunctionFailureException || error instanceof ProtocolError) {
                LOG.trace("[{}] Unrecoverable error, rethrowing", (Object)this.logPrefix);
                metricUpdater.incrementCounter(DefaultNodeMetric.OTHER_ERRORS, CqlRequestHandler.this.executionProfile.getName());
                this.trackNodeError(this.node, error, -1L);
                CqlRequestHandler.this.setFinalError(error, this.node, this.execution);
            } else {
                RetryDecision decision;
                if (error instanceof ReadTimeoutException) {
                    ReadTimeoutException readTimeout = (ReadTimeoutException)error;
                    decision = CqlRequestHandler.this.retryPolicy.onReadTimeout(CqlRequestHandler.this.statement, readTimeout.getConsistencyLevel(), readTimeout.getBlockFor(), readTimeout.getReceived(), readTimeout.wasDataPresent(), this.retryCount);
                    this.updateErrorMetrics(metricUpdater, decision, DefaultNodeMetric.READ_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT);
                } else if (error instanceof WriteTimeoutException) {
                    WriteTimeoutException writeTimeout = (WriteTimeoutException)error;
                    decision = CqlRequestHandler.this.isIdempotent ? CqlRequestHandler.this.retryPolicy.onWriteTimeout(CqlRequestHandler.this.statement, writeTimeout.getConsistencyLevel(), writeTimeout.getWriteType(), writeTimeout.getBlockFor(), writeTimeout.getReceived(), this.retryCount) : RetryDecision.RETHROW;
                    this.updateErrorMetrics(metricUpdater, decision, DefaultNodeMetric.WRITE_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT);
                } else if (error instanceof UnavailableException) {
                    UnavailableException unavailable = (UnavailableException)error;
                    decision = CqlRequestHandler.this.retryPolicy.onUnavailable(CqlRequestHandler.this.statement, unavailable.getConsistencyLevel(), unavailable.getRequired(), unavailable.getAlive(), this.retryCount);
                    this.updateErrorMetrics(metricUpdater, decision, DefaultNodeMetric.UNAVAILABLES, DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, DefaultNodeMetric.IGNORES_ON_UNAVAILABLE);
                } else {
                    decision = CqlRequestHandler.this.isIdempotent ? CqlRequestHandler.this.retryPolicy.onErrorResponse(CqlRequestHandler.this.statement, error, this.retryCount) : RetryDecision.RETHROW;
                    this.updateErrorMetrics(metricUpdater, decision, DefaultNodeMetric.OTHER_ERRORS, DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, DefaultNodeMetric.IGNORES_ON_OTHER_ERROR);
                }
                this.processRetryDecision(decision, error);
            }
        }

        private void processRetryDecision(RetryDecision decision, Throwable error) {
            LOG.trace("[{}] Processing retry decision {}", (Object)this.logPrefix, (Object)decision);
            switch (decision) {
                case RETRY_SAME: {
                    CqlRequestHandler.this.recordError(this.node, error);
                    this.trackNodeError(this.node, error, -1L);
                    CqlRequestHandler.this.sendRequest(this.node, this.queryPlan, this.execution, this.retryCount + 1, false);
                    break;
                }
                case RETRY_NEXT: {
                    CqlRequestHandler.this.recordError(this.node, error);
                    this.trackNodeError(this.node, error, -1L);
                    CqlRequestHandler.this.sendRequest(null, this.queryPlan, this.execution, this.retryCount + 1, false);
                    break;
                }
                case RETHROW: {
                    this.trackNodeError(this.node, error, -1L);
                    CqlRequestHandler.this.setFinalError(error, this.node, this.execution);
                    break;
                }
                case IGNORE: {
                    CqlRequestHandler.this.setFinalResult((Result)com.datastax.oss.protocol.internal.response.result.Void.INSTANCE, null, true, this);
                }
            }
        }

        private void updateErrorMetrics(NodeMetricUpdater metricUpdater, RetryDecision decision, DefaultNodeMetric error, DefaultNodeMetric retriesOnError, DefaultNodeMetric ignoresOnError) {
            metricUpdater.incrementCounter(error, CqlRequestHandler.this.executionProfile.getName());
            switch (decision) {
                case RETRY_SAME: 
                case RETRY_NEXT: {
                    metricUpdater.incrementCounter(DefaultNodeMetric.RETRIES, CqlRequestHandler.this.executionProfile.getName());
                    metricUpdater.incrementCounter(retriesOnError, CqlRequestHandler.this.executionProfile.getName());
                    break;
                }
                case IGNORE: {
                    metricUpdater.incrementCounter(DefaultNodeMetric.IGNORES, CqlRequestHandler.this.executionProfile.getName());
                    metricUpdater.incrementCounter(ignoresOnError, CqlRequestHandler.this.executionProfile.getName());
                    break;
                }
            }
        }

        @Override
        public void onFailure(Throwable error) {
            RetryDecision decision;
            CqlRequestHandler.this.inFlightCallbacks.remove(this);
            if (CqlRequestHandler.this.result.isDone()) {
                return;
            }
            LOG.trace("[{}] Request failure, processing: {}", (Object)this.logPrefix, (Object)error);
            if (!CqlRequestHandler.this.isIdempotent || error instanceof FrameTooLongException) {
                decision = RetryDecision.RETHROW;
            } else {
                try {
                    decision = CqlRequestHandler.this.retryPolicy.onRequestAborted(CqlRequestHandler.this.statement, error, this.retryCount);
                }
                catch (Throwable cause) {
                    CqlRequestHandler.this.setFinalError(new IllegalStateException("Unexpected error while invoking the retry policy", cause), null, this.execution);
                    return;
                }
            }
            this.processRetryDecision(decision, error);
            this.updateErrorMetrics(((DefaultNode)this.node).getMetricUpdater(), decision, DefaultNodeMetric.ABORTED_REQUESTS, DefaultNodeMetric.RETRIES_ON_ABORTED, DefaultNodeMetric.IGNORES_ON_ABORTED);
        }

        public void cancel() {
            try {
                if (!this.channel.closeFuture().isDone()) {
                    this.channel.cancel(this);
                }
            }
            catch (Throwable t) {
                Loggers.warnWithException(LOG, "[{}] Error cancelling", this.logPrefix, t);
            }
        }

        private void trackNodeError(Node node, Throwable error, long nodeResponseTimeNanos) {
            if (CqlRequestHandler.this.requestTracker instanceof NoopRequestTracker) {
                return;
            }
            if (nodeResponseTimeNanos == -1L) {
                nodeResponseTimeNanos = System.nanoTime();
            }
            long latencyNanos = nodeResponseTimeNanos - this.nodeStartTimeNanos;
            CqlRequestHandler.this.requestTracker.onNodeError(CqlRequestHandler.this.statement, error, latencyNanos, CqlRequestHandler.this.executionProfile, node, this.logPrefix);
        }

        public String toString() {
            return this.logPrefix;
        }
    }
}

