/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.data.time;

import com.datastax.dse.driver.internal.core.search.DateRangeUtil;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Map;

public enum DateRangePrecision {
    MILLISECOND(6, ChronoUnit.MILLIS, new DateTimeFormatterBuilder().parseCaseSensitive().parseStrict().appendPattern("uuuu-MM-dd'T'HH:mm:ss.SSS").optionalStart().appendZoneId().optionalEnd().toFormatter().withZone(ZoneOffset.UTC).withLocale(Locale.ROOT)),
    SECOND(5, ChronoUnit.SECONDS, new DateTimeFormatterBuilder().parseCaseSensitive().parseStrict().appendPattern("uuuu-MM-dd'T'HH:mm:ss").parseDefaulting(ChronoField.MILLI_OF_SECOND, 0L).toFormatter().withZone(ZoneOffset.UTC).withLocale(Locale.ROOT)),
    MINUTE(4, ChronoUnit.MINUTES, new DateTimeFormatterBuilder().parseCaseSensitive().parseStrict().appendPattern("uuuu-MM-dd'T'HH:mm").parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.MILLI_OF_SECOND, 0L).toFormatter().withZone(ZoneOffset.UTC).withLocale(Locale.ROOT)),
    HOUR(3, ChronoUnit.HOURS, new DateTimeFormatterBuilder().parseCaseSensitive().parseStrict().appendPattern("uuuu-MM-dd'T'HH").parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.MILLI_OF_SECOND, 0L).toFormatter().withZone(ZoneOffset.UTC).withLocale(Locale.ROOT)),
    DAY(2, ChronoUnit.DAYS, new DateTimeFormatterBuilder().parseCaseSensitive().parseStrict().appendPattern("uuuu-MM-dd").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.MILLI_OF_SECOND, 0L).toFormatter().withZone(ZoneOffset.UTC).withLocale(Locale.ROOT)),
    MONTH(1, ChronoUnit.MONTHS, new DateTimeFormatterBuilder().parseCaseSensitive().parseStrict().appendPattern("uuuu-MM").parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.MILLI_OF_SECOND, 0L).toFormatter().withZone(ZoneOffset.UTC).withLocale(Locale.ROOT)),
    YEAR(0, ChronoUnit.YEARS, new DateTimeFormatterBuilder().parseCaseSensitive().parseStrict().appendPattern("uuuu").parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.MILLI_OF_SECOND, 0L).toFormatter().withZone(ZoneOffset.UTC).withLocale(Locale.ROOT));

    private final byte encoding;
    private final ChronoUnit roundingUnit;
    private final DateTimeFormatter formatter;
    private static final Map<Byte, DateRangePrecision> ENCODINGS;

    private DateRangePrecision(int encoding, ChronoUnit roundingUnit, DateTimeFormatter formatter) {
        this.encoding = (byte)encoding;
        this.roundingUnit = roundingUnit;
        this.formatter = formatter;
    }

    public static DateRangePrecision fromEncoding(byte encoding) {
        DateRangePrecision precision = ENCODINGS.get(encoding);
        if (precision == null) {
            throw new IllegalArgumentException("Invalid precision encoding: " + encoding);
        }
        return precision;
    }

    public byte getEncoding() {
        return this.encoding;
    }

    @NonNull
    public ZonedDateTime roundUp(@NonNull ZonedDateTime timestamp) {
        Preconditions.checkNotNull((Object)timestamp);
        return DateRangeUtil.roundUp(timestamp, this.roundingUnit);
    }

    @NonNull
    public ZonedDateTime roundDown(@NonNull ZonedDateTime timestamp) {
        Preconditions.checkNotNull((Object)timestamp);
        return DateRangeUtil.roundDown(timestamp, this.roundingUnit);
    }

    public String format(ZonedDateTime timestamp) {
        return this.formatter.format(timestamp);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DateRangePrecision precision : DateRangePrecision.values()) {
            builder.put((Object)precision.encoding, (Object)precision);
        }
        ENCODINGS = builder.build();
    }
}

