/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.CDCToken;
import com.datastax.oss.driver.internal.core.metadata.token.CDCTokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CDCTokenFactory
implements TokenFactory {
    public static final String PARTITIONER_NAME = "com.scylladb.dht.CDCPartitioner";
    public static final CDCToken MIN_TOKEN = new CDCToken(Long.MIN_VALUE);
    public static final CDCToken MAX_TOKEN = new CDCToken(Long.MAX_VALUE);
    private static final Logger logger = LoggerFactory.getLogger(CDCTokenFactory.class);
    private static final int CDC_PARTITION_KEY_LENGTH = 16;
    private static final long VERSION_MASK = 15L;
    private static final int MIN_SUPPORTED_VERSION = 1;
    private static final int MAX_SUPPORTED_VERSION = 1;

    @Override
    public String getPartitionerName() {
        return PARTITIONER_NAME;
    }

    @Override
    public Token hash(ByteBuffer partitionKey) {
        int offset = partitionKey.position();
        int length = partitionKey.remaining();
        if (length != 16) {
            logger.warn("CDC partition key has invalid length: expected {} bytes, but got {} bytes", (Object)16, (Object)length);
        }
        if (length < 8) {
            return MIN_TOKEN;
        }
        long upperDword = partitionKey.getLong(offset + 0);
        if (length != 16) {
            return new CDCToken(upperDword);
        }
        long lowerDword = partitionKey.getLong(offset + 8);
        long version = lowerDword & 0xFL;
        if (version < 1L || version > 1L) {
            logger.warn("CDC partition key version {} is not supported", (Object)version);
        }
        return new CDCToken(upperDword);
    }

    @Override
    public Token parse(String tokenString) {
        return new CDCToken(Long.parseLong(tokenString));
    }

    @Override
    public String format(Token token) {
        Preconditions.checkArgument((boolean)(token instanceof CDCToken), (Object)"Can only format CDCToken instances");
        return Long.toString(((CDCToken)token).getValue());
    }

    @Override
    public Token minToken() {
        return MIN_TOKEN;
    }

    @Override
    public TokenRange range(Token start, Token end) {
        Preconditions.checkArgument((start instanceof CDCToken && end instanceof CDCToken ? 1 : 0) != 0, (Object)"Can only build ranges of CDCToken instances");
        return new CDCTokenRange((CDCToken)start, (CDCToken)end);
    }
}

