/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.internal.core.cql.DefaultBatchStatement;
import com.datastax.oss.driver.internal.core.time.ServerSideTimestampGenerator;
import com.datastax.oss.driver.internal.core.util.Sizes;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface BatchStatement
extends Statement<BatchStatement>,
Iterable<BatchableStatement<?>> {
    @NonNull
    public static BatchStatement newInstance(@NonNull BatchType batchType) {
        return new DefaultBatchStatement(batchType, new ArrayList(), null, null, null, null, null, null, Collections.emptyMap(), null, false, Long.MIN_VALUE, null, Integer.MIN_VALUE, null, null, null, null, Integer.MIN_VALUE, null);
    }

    @NonNull
    public static BatchStatement newInstance(@NonNull BatchType batchType, @NonNull Iterable<BatchableStatement<?>> statements) {
        return new DefaultBatchStatement(batchType, (List<BatchableStatement<?>>)ImmutableList.copyOf(statements), null, null, null, null, null, null, Collections.emptyMap(), null, false, Long.MIN_VALUE, null, Integer.MIN_VALUE, null, null, null, null, Integer.MIN_VALUE, null);
    }

    @NonNull
    public static BatchStatement newInstance(@NonNull BatchType batchType, BatchableStatement<?> ... statements) {
        return new DefaultBatchStatement(batchType, (List<BatchableStatement<?>>)ImmutableList.copyOf((Object[])statements), null, null, null, null, null, null, Collections.emptyMap(), null, false, Long.MIN_VALUE, null, Integer.MIN_VALUE, null, null, null, null, Integer.MIN_VALUE, null);
    }

    @NonNull
    public static BatchStatementBuilder builder(@NonNull BatchType batchType) {
        return new BatchStatementBuilder(batchType);
    }

    @NonNull
    public static BatchStatementBuilder builder(@NonNull BatchStatement template) {
        return new BatchStatementBuilder(template);
    }

    @NonNull
    public BatchType getBatchType();

    @NonNull
    @CheckReturnValue
    public BatchStatement setBatchType(@NonNull BatchType var1);

    @NonNull
    @CheckReturnValue
    public BatchStatement setKeyspace(@Nullable CqlIdentifier var1);

    @NonNull
    @CheckReturnValue
    default public BatchStatement setKeyspace(@NonNull String newKeyspaceName) {
        return this.setKeyspace(CqlIdentifier.fromCql(newKeyspaceName));
    }

    @NonNull
    @CheckReturnValue
    public BatchStatement add(@NonNull BatchableStatement<?> var1);

    @NonNull
    @CheckReturnValue
    public BatchStatement addAll(@NonNull Iterable<? extends BatchableStatement<?>> var1);

    @NonNull
    @CheckReturnValue
    default public BatchStatement addAll(BatchableStatement<?> ... statements) {
        return this.addAll(Arrays.asList(statements));
    }

    public int size();

    @NonNull
    @CheckReturnValue
    public BatchStatement clear();

    @Override
    default public int computeSizeInBytes(@NonNull DriverContext context) {
        int size = Sizes.minimumStatementSize(this, context);
        ++size;
        size += 2;
        for (BatchableStatement batchableStatement : this) {
            size += Sizes.sizeOfInnerBatchStatementInBytes(batchableStatement, context.getProtocolVersion(), context.getCodecRegistry()).intValue();
        }
        if (this.getKeyspace() != null) {
            size += PrimitiveSizes.sizeOfString((String)this.getKeyspace().asInternal());
        }
        if (!(context.getTimestampGenerator() instanceof ServerSideTimestampGenerator) || this.getQueryTimestamp() != Long.MIN_VALUE) {
            size += 8;
        }
        return size;
    }
}

