/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Objects;

public class DefaultEndPoint
implements EndPoint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final InetSocketAddress address;
    private final String metricPrefix;

    public DefaultEndPoint(InetSocketAddress address) {
        this.address = Objects.requireNonNull(address, "address can't be null");
        this.metricPrefix = DefaultEndPoint.buildMetricPrefix(address);
    }

    @Override
    @NonNull
    public InetSocketAddress resolve() {
        return this.address;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DefaultEndPoint) {
            DefaultEndPoint that = (DefaultEndPoint)other;
            return this.address.equals(that.address);
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public String toString() {
        return this.address.toString();
    }

    @Override
    @NonNull
    public String asMetricPrefix() {
        return this.metricPrefix;
    }

    private static String buildMetricPrefix(InetSocketAddress address) {
        String hostString = address.getHostString();
        if (hostString == null) {
            throw new IllegalArgumentException("Could not extract a host string from provided address " + address);
        }
        return hostString.replace('.', '_') + ':' + address.getPort();
    }
}

