/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.metadata.schema.Describable;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.metadata.schema.ScriptBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;

public interface UserDefinedType
extends DataType,
Describable {
    @Nullable
    public CqlIdentifier getKeyspace();

    @NonNull
    public CqlIdentifier getName();

    public boolean isFrozen();

    @NonNull
    public List<CqlIdentifier> getFieldNames();

    public int firstIndexOf(CqlIdentifier var1);

    public int firstIndexOf(String var1);

    default public boolean contains(@NonNull CqlIdentifier id) {
        return this.firstIndexOf(id) >= 0;
    }

    default public boolean contains(@NonNull String name) {
        return this.firstIndexOf(name) >= 0;
    }

    @NonNull
    public List<DataType> getFieldTypes();

    @NonNull
    public UserDefinedType copy(boolean var1);

    @NonNull
    public UdtValue newValue();

    @NonNull
    public UdtValue newValue(Object ... var1);

    @NonNull
    public AttachmentPoint getAttachmentPoint();

    @Override
    @NonNull
    default public String asCql(boolean includeFrozen, boolean pretty) {
        if (this.getKeyspace() != null) {
            String template = this.isFrozen() && includeFrozen ? "frozen<%s.%s>" : "%s.%s";
            return String.format(template, this.getKeyspace().asCql(pretty), this.getName().asCql(pretty));
        }
        String template = this.isFrozen() && includeFrozen ? "frozen<%s>" : "%s";
        return String.format(template, this.getName().asCql(pretty));
    }

    @Override
    @NonNull
    default public String describe(boolean pretty) {
        ScriptBuilder builder = new ScriptBuilder(pretty);
        builder.append("CREATE TYPE ").append(this.getKeyspace()).append(".").append(this.getName()).append(" (").newLine().increaseIndent();
        List<CqlIdentifier> fieldNames = this.getFieldNames();
        List<DataType> fieldTypes = this.getFieldTypes();
        int fieldCount = fieldNames.size();
        for (int i = 0; i < fieldCount; ++i) {
            builder.append(fieldNames.get(i)).append(" ").append(fieldTypes.get(i).asCql(true, pretty));
            if (i < fieldCount - 1) {
                builder.append(",");
            }
            builder.newLine();
        }
        builder.decreaseIndent().append(");");
        return builder.build();
    }

    @Override
    @NonNull
    default public String describeWithChildren(boolean pretty) {
        return this.describe(pretty);
    }

    @Override
    default public int getProtocolCode() {
        return 48;
    }
}

