/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.cql.QueryTrace;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletionStage;

public interface ExecutionInfo {
    @NonNull
    default public Request getRequest() {
        return this.getStatement();
    }

    @Deprecated
    @NonNull
    public Statement<?> getStatement();

    @Nullable
    public Node getCoordinator();

    public int getSpeculativeExecutionCount();

    public int getSuccessfulExecutionIndex();

    @NonNull
    public List<Map.Entry<Node, Throwable>> getErrors();

    @Nullable
    public ByteBuffer getPagingState();

    @NonNull
    public List<String> getWarnings();

    @NonNull
    public Map<String, ByteBuffer> getIncomingPayload();

    public boolean isSchemaInAgreement();

    @Nullable
    public UUID getTracingId();

    @NonNull
    public CompletionStage<QueryTrace> getQueryTraceAsync();

    @NonNull
    default public QueryTrace getQueryTrace() {
        BlockingOperation.checkNotDriverThread();
        return CompletableFutures.getUninterruptibly(this.getQueryTraceAsync());
    }

    public int getResponseSizeInBytes();

    public int getCompressedResponseSizeInBytes();
}

