/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.shaded.netty.buffer.ByteBuf;
import com.datastax.oss.driver.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.oss.driver.shaded.netty.channel.ChannelOutboundHandlerAdapter;
import com.datastax.oss.driver.shaded.netty.channel.ChannelPromise;

public class OutboundTrafficMeter
extends ChannelOutboundHandlerAdapter {
    private final NodeMetricUpdater nodeMetricUpdater;
    private final SessionMetricUpdater sessionMetricUpdater;

    OutboundTrafficMeter(NodeMetricUpdater nodeMetricUpdater, SessionMetricUpdater sessionMetricUpdater) {
        this.nodeMetricUpdater = nodeMetricUpdater;
        this.sessionMetricUpdater = sessionMetricUpdater;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            int bytes = ((ByteBuf)msg).readableBytes();
            this.nodeMetricUpdater.markMeter(DefaultNodeMetric.BYTES_SENT, null, bytes);
            this.sessionMetricUpdater.markMeter(DefaultSessionMetric.BYTES_SENT, null, bytes);
        }
        super.write(ctx, msg, promise);
    }
}

