/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.RequestRoutingType;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.internal.core.cql.DefaultSimpleStatement;
import com.datastax.oss.driver.internal.core.time.ServerSideTimestampGenerator;
import com.datastax.oss.driver.internal.core.util.Sizes;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public interface SimpleStatement
extends BatchableStatement<SimpleStatement> {
    public static SimpleStatement newInstance(@NonNull String cqlQuery) {
        return new DefaultSimpleStatement(cqlQuery, (List<Object>)NullAllowingImmutableList.of(), (Map<CqlIdentifier, Object>)NullAllowingImmutableMap.of(), null, null, null, null, null, null, (Map<String, ByteBuffer>)NullAllowingImmutableMap.of(), null, false, Long.MIN_VALUE, null, Integer.MIN_VALUE, null, null, null, null, Integer.MIN_VALUE, RequestRoutingType.REGULAR);
    }

    public static SimpleStatement newInstance(@NonNull String cqlQuery, Object ... positionalValues) {
        return new DefaultSimpleStatement(cqlQuery, (List<Object>)NullAllowingImmutableList.of((Object[])positionalValues), (Map<CqlIdentifier, Object>)NullAllowingImmutableMap.of(), null, null, null, null, null, null, (Map<String, ByteBuffer>)NullAllowingImmutableMap.of(), null, false, Long.MIN_VALUE, null, Integer.MIN_VALUE, null, null, null, null, Integer.MIN_VALUE, RequestRoutingType.REGULAR);
    }

    public static SimpleStatement newInstance(@NonNull String cqlQuery, @NonNull Map<String, Object> namedValues) {
        return new DefaultSimpleStatement(cqlQuery, (List<Object>)NullAllowingImmutableList.of(), DefaultSimpleStatement.wrapKeys(namedValues), null, null, null, null, null, null, (Map<String, ByteBuffer>)NullAllowingImmutableMap.of(), null, false, Long.MIN_VALUE, null, Integer.MIN_VALUE, null, null, null, null, Integer.MIN_VALUE, RequestRoutingType.REGULAR);
    }

    @NonNull
    public static SimpleStatementBuilder builder(@NonNull String query) {
        return new SimpleStatementBuilder(query);
    }

    @NonNull
    public static SimpleStatementBuilder builder(@NonNull SimpleStatement template) {
        return new SimpleStatementBuilder(template);
    }

    @NonNull
    public String getQuery();

    @NonNull
    @CheckReturnValue
    public SimpleStatement setQuery(@NonNull String var1);

    @NonNull
    @CheckReturnValue
    public SimpleStatement setKeyspace(@Nullable CqlIdentifier var1);

    @NonNull
    @CheckReturnValue
    default public SimpleStatement setKeyspace(@NonNull String newKeyspaceName) {
        return this.setKeyspace(CqlIdentifier.fromCql(newKeyspaceName));
    }

    @NonNull
    public List<Object> getPositionalValues();

    @NonNull
    @CheckReturnValue
    public SimpleStatement setPositionalValues(@NonNull List<Object> var1);

    @NonNull
    public Map<CqlIdentifier, Object> getNamedValues();

    @NonNull
    @CheckReturnValue
    public SimpleStatement setNamedValuesWithIds(@NonNull Map<CqlIdentifier, Object> var1);

    @NonNull
    @CheckReturnValue
    default public SimpleStatement setNamedValues(@NonNull Map<String, Object> newNamedValues) {
        return this.setNamedValuesWithIds(DefaultSimpleStatement.wrapKeys(newNamedValues));
    }

    @Override
    default public int computeSizeInBytes(@NonNull DriverContext context) {
        int size = Sizes.minimumStatementSize(this, context);
        size += PrimitiveSizes.sizeOfLongString((String)this.getQuery());
        size += Sizes.sizeOfSimpleStatementValues(this, context.getProtocolVersion(), context.getCodecRegistry());
        if (this.getKeyspace() != null) {
            size += PrimitiveSizes.sizeOfString((String)this.getKeyspace().asInternal());
        }
        size += 4;
        if (this.getPagingState() != null) {
            size += PrimitiveSizes.sizeOfBytes((ByteBuffer)this.getPagingState());
        }
        if (!(context.getTimestampGenerator() instanceof ServerSideTimestampGenerator) || this.getQueryTimestamp() != Long.MIN_VALUE) {
            size += 8;
        }
        return size;
    }
}

