/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.continuous;

import com.datastax.dse.driver.api.core.cql.continuous.ContinuousAsyncResultSet;
import com.datastax.dse.driver.api.core.cql.continuous.ContinuousResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class DefaultContinuousResultSet
implements ContinuousResultSet {
    private final RowIterator iterator;
    private final List<ExecutionInfo> executionInfos = new ArrayList<ExecutionInfo>();
    private final ColumnDefinitions columnDefinitions;

    public DefaultContinuousResultSet(ContinuousAsyncResultSet firstPage) {
        this.iterator = new RowIterator(firstPage);
        this.columnDefinitions = firstPage.getColumnDefinitions();
        this.executionInfos.add(firstPage.getExecutionInfo());
    }

    @Override
    public void cancel() {
        this.iterator.cancel();
    }

    @Override
    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.columnDefinitions;
    }

    @Override
    @NonNull
    public List<ExecutionInfo> getExecutionInfos() {
        return this.executionInfos;
    }

    @Override
    @NonNull
    public Iterator<Row> iterator() {
        return this.iterator;
    }

    @Override
    public boolean isFullyFetched() {
        return this.iterator.isFullyFetched();
    }

    @Override
    public int getAvailableWithoutFetching() {
        return this.iterator.remaining();
    }

    @Override
    public boolean wasApplied() {
        return this.iterator.wasApplied();
    }

    private class RowIterator
    extends CountingIterator<Row> {
        private ContinuousAsyncResultSet currentPage;
        private Iterator<Row> currentRows;
        private boolean cancelled;

        private RowIterator(ContinuousAsyncResultSet firstPage) {
            super(firstPage.remaining());
            this.cancelled = false;
            this.currentPage = firstPage;
            this.currentRows = firstPage.currentPage().iterator();
        }

        @Override
        protected Row computeNext() {
            this.maybeMoveToNextPage();
            return this.currentRows.hasNext() ? this.currentRows.next() : (Row)this.endOfData();
        }

        private void maybeMoveToNextPage() {
            if (!this.cancelled && !this.currentRows.hasNext() && this.currentPage.hasMorePages()) {
                ContinuousAsyncResultSet nextPage;
                BlockingOperation.checkNotDriverThread();
                this.currentPage = nextPage = (ContinuousAsyncResultSet)CompletableFutures.getUninterruptibly(this.currentPage.fetchNextPage());
                this.remaining += this.currentPage.remaining();
                this.currentRows = nextPage.currentPage().iterator();
                DefaultContinuousResultSet.this.executionInfos.add(nextPage.getExecutionInfo());
            }
        }

        private boolean isFullyFetched() {
            return !this.currentPage.hasMorePages();
        }

        private boolean wasApplied() {
            return this.currentPage.wasApplied();
        }

        private void cancel() {
            this.currentPage.cancel();
            this.cancelled = true;
        }
    }
}

