/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metadata;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.TabletMap;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public interface Metadata {
    @NonNull
    public Map<UUID, Node> getNodes();

    @NonNull
    default public Optional<Node> findNode(@NonNull EndPoint endPoint) {
        for (Node node : this.getNodes().values()) {
            if (!node.getEndPoint().equals(endPoint)) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    @NonNull
    default public Optional<Node> findNode(@NonNull InetSocketAddress broadcastRpcAddress) {
        for (Node node : this.getNodes().values()) {
            Optional<InetSocketAddress> o = node.getBroadcastRpcAddress();
            if (!o.isPresent() || !o.get().equals(broadcastRpcAddress)) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    @NonNull
    public Map<CqlIdentifier, KeyspaceMetadata> getKeyspaces();

    @NonNull
    default public Optional<KeyspaceMetadata> getKeyspace(@NonNull CqlIdentifier keyspaceId) {
        return Optional.ofNullable(this.getKeyspaces().get(keyspaceId));
    }

    @NonNull
    default public Optional<KeyspaceMetadata> getKeyspace(@NonNull String keyspaceName) {
        return this.getKeyspace(CqlIdentifier.fromCql(keyspaceName));
    }

    @NonNull
    public Optional<TokenMap> getTokenMap();

    public Optional<TabletMap> getTabletMap();

    @NonNull
    default public Optional<String> getClusterName() {
        return Optional.empty();
    }
}

