/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.binary;

import com.datastax.dse.driver.internal.core.graph.binary.AbstractSimpleGraphBinaryCustomSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryUtils;
import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;

public abstract class AbstractDynamicGraphBinaryCustomSerializer<T>
extends AbstractSimpleGraphBinaryCustomSerializer<T> {
    protected abstract void writeDynamicCustomValue(T var1, Buffer var2, GraphBinaryWriter var3) throws IOException;

    protected abstract T readDynamicCustomValue(Buffer var1, GraphBinaryReader var2) throws IOException;

    @Override
    protected T readCustomValue(int valueLength, Buffer buffer, GraphBinaryReader context) throws IOException {
        int initialIndex = buffer.readerIndex();
        T read = this.readDynamicCustomValue(buffer, context);
        this.checkValueSize(valueLength, buffer.readerIndex() - initialIndex);
        return read;
    }

    @Override
    protected void writeCustomValue(T value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        int valueLengthIndex = buffer.writerIndex();
        buffer.writeInt(0);
        this.writeDynamicCustomValue(value, buffer, context);
        int valueLength = buffer.writerIndex() - valueLengthIndex - GraphBinaryUtils.sizeOfInt();
        buffer.markWriterIndex().writerIndex(valueLengthIndex).writeInt(valueLength).resetWriterIndex();
    }
}

