/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.protocol.Lz4Compressor;
import com.datastax.oss.driver.internal.core.protocol.SnappyCompressor;
import com.datastax.oss.driver.shaded.netty.buffer.ByteBuf;
import com.datastax.oss.protocol.internal.Compressor;
import java.util.Locale;

public class BuiltInCompressors {
    public static Compressor<ByteBuf> newInstance(String name, DriverContext context) {
        switch (name.toLowerCase(Locale.ROOT)) {
            case "lz4": {
                return new Lz4Compressor(context);
            }
            case "snappy": {
                return new SnappyCompressor(context);
            }
            case "none": {
                return Compressor.none();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported compression algorithm '%s' (from configuration option %s)", name, DefaultDriverOption.PROTOCOL_COMPRESSION.getPath()));
    }
}

