/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.data.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultGeometry;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPolygon;
import com.datastax.oss.driver.shaded.esri.core.geometry.ogc.OGCPolygon;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.List;

public interface Polygon
extends Geometry {
    @NonNull
    public static Polygon fromWellKnownText(@NonNull String source) {
        return new DefaultPolygon(DefaultGeometry.fromOgcWellKnownText(source, OGCPolygon.class));
    }

    @NonNull
    public static Polygon fromWellKnownBinary(@NonNull ByteBuffer source) {
        return new DefaultPolygon(DefaultGeometry.fromOgcWellKnownBinary(source, OGCPolygon.class));
    }

    @NonNull
    public static Polygon fromGeoJson(@NonNull String source) {
        return new DefaultPolygon(DefaultGeometry.fromOgcGeoJson(source, OGCPolygon.class));
    }

    @NonNull
    public static Polygon fromPoints(@NonNull Point p1, @NonNull Point p2, @NonNull Point p3, Point ... pn) {
        return new DefaultPolygon(p1, p2, p3, pn);
    }

    @NonNull
    public static Builder builder() {
        return new DefaultPolygon.Builder();
    }

    @NonNull
    public List<Point> getExteriorRing();

    @NonNull
    public List<List<Point>> getInteriorRings();

    public static interface Builder {
        @NonNull
        public Builder addRing(@NonNull Point var1, @NonNull Point var2, @NonNull Point var3, Point ... var4);

        @NonNull
        public Polygon build();
    }
}

