/*
 * Decompiled with CFR 0.152.
 */
package com.scottyab.aescrypt;

import android.util.Base64;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AESCrypt {
    private static final String TAG = "AESCrypt";
    private static final String AES_MODE = "AES/CBC/PKCS7Padding";
    private static final String CHARSET = "UTF-8";
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final byte[] ivBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static boolean DEBUG_LOG_ENABLED = false;

    private static SecretKeySpec generateKey(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITHM);
        byte[] bytes = password.getBytes(CHARSET);
        digest.update(bytes, 0, bytes.length);
        byte[] key = digest.digest();
        AESCrypt.log("SHA-256 key ", key);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        return secretKeySpec;
    }

    public static String encrypt(String password, String message) throws GeneralSecurityException {
        try {
            SecretKeySpec key = AESCrypt.generateKey(password);
            AESCrypt.log("message", message);
            byte[] cipherText = AESCrypt.encrypt(key, ivBytes, message.getBytes(CHARSET));
            String encoded = Base64.encodeToString((byte[])cipherText, (int)2);
            AESCrypt.log("Base64.NO_WRAP", encoded);
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            if (DEBUG_LOG_ENABLED) {
                Log.e((String)TAG, (String)"UnsupportedEncodingException ", (Throwable)e);
            }
            throw new GeneralSecurityException(e);
        }
    }

    public static byte[] encrypt(SecretKeySpec key, byte[] iv, byte[] message) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)key, ivSpec);
        byte[] cipherText = cipher.doFinal(message);
        AESCrypt.log("cipherText", cipherText);
        return cipherText;
    }

    public static String decrypt(String password, String base64EncodedCipherText) throws GeneralSecurityException {
        try {
            SecretKeySpec key = AESCrypt.generateKey(password);
            AESCrypt.log("base64EncodedCipherText", base64EncodedCipherText);
            byte[] decodedCipherText = Base64.decode((String)base64EncodedCipherText, (int)2);
            AESCrypt.log("decodedCipherText", decodedCipherText);
            byte[] decryptedBytes = AESCrypt.decrypt(key, ivBytes, decodedCipherText);
            AESCrypt.log("decryptedBytes", decryptedBytes);
            String message = new String(decryptedBytes, CHARSET);
            AESCrypt.log("message", message);
            return message;
        }
        catch (UnsupportedEncodingException e) {
            if (DEBUG_LOG_ENABLED) {
                Log.e((String)TAG, (String)"UnsupportedEncodingException ", (Throwable)e);
            }
            throw new GeneralSecurityException(e);
        }
    }

    public static byte[] decrypt(SecretKeySpec key, byte[] iv, byte[] decodedCipherText) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)key, ivSpec);
        byte[] decryptedBytes = cipher.doFinal(decodedCipherText);
        AESCrypt.log("decryptedBytes", decryptedBytes);
        return decryptedBytes;
    }

    private static void log(String what, byte[] bytes) {
        if (DEBUG_LOG_ENABLED) {
            Log.d((String)TAG, (String)(what + "[" + bytes.length + "] [" + AESCrypt.bytesToHex(bytes) + "]"));
        }
    }

    private static void log(String what, String value) {
        if (DEBUG_LOG_ENABLED) {
            Log.d((String)TAG, (String)(what + "[" + value.length() + "] [" + value + "]"));
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private AESCrypt() {
    }
}

